import { ConfigKeys } from '../types/config.types';
import { LoginCredentials, WebdavConfig } from '../types/command.types';
export declare class ConfigService {
    static readonly INTERNXT_CLI_DATA_DIR: string;
    static readonly INTERNXT_CLI_LOGS_DIR: string;
    static readonly INTERNXT_TMP_DIR: string;
    static readonly CREDENTIALS_FILE: string;
    static readonly DRIVE_SQLITE_FILE: string;
    static readonly WEBDAV_SSL_CERTS_DIR: string;
    static readonly WEBDAV_CONFIGS_FILE: string;
    static readonly WEBDAV_DEFAULT_HOST = "127.0.0.1";
    static readonly WEBDAV_DEFAULT_PORT = "3005";
    static readonly WEBDAV_DEFAULT_PROTOCOL = "https";
    static readonly WEBDAV_DEFAULT_TIMEOUT = 0;
    static readonly WEBDAV_DEFAULT_CREATE_FULL_PATH = true;
    static readonly instance: ConfigService;
    get: (key: keyof ConfigKeys) => string;
    saveUser: (loginCredentials: LoginCredentials) => Promise<void>;
    clearUser: () => Promise<void>;
    readUser: () => Promise<LoginCredentials | undefined>;
    saveWebdavConfig: (webdavConfig: WebdavConfig) => Promise<void>;
    readWebdavConfig: () => Promise<WebdavConfig>;
    ensureInternxtCliDataDirExists: () => Promise<void>;
    ensureWebdavCertsDirExists: () => Promise<void>;
    ensureInternxtLogsDirExists: () => Promise<void>;
}
