"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const whoami_1 = __importDefault(require("../../commands/whoami"));
const login_1 = __importDefault(require("../../commands/login"));
const login_legacy_1 = __importDefault(require("../../commands/login-legacy"));
const logout_1 = __importDefault(require("../../commands/logout"));
const logs_1 = __importDefault(require("../../commands/logs"));
const cli_utils_1 = require("../../utils/cli.utils");
const sdk_manager_service_1 = require("../../services/sdk-manager.service");
const auth_service_1 = require("../../services/auth.service");
const webdav_1 = __importDefault(require("../../commands/webdav"));
const webdav_config_1 = __importDefault(require("../../commands/webdav-config"));
const CommandsToSkip = [whoami_1.default, login_1.default, login_legacy_1.default, logout_1.default, logs_1.default, webdav_1.default, webdav_config_1.default];
const hook = async function (opts) {
    const { Command, argv } = opts;
    const jsonFlag = argv.includes('--json');
    if (!CommandsToSkip.map((command) => command.name).includes(Command.name)) {
        cli_utils_1.CLIUtils.doing('Checking credentials', jsonFlag);
        try {
            const { token } = await auth_service_1.AuthService.instance.getAuthDetails();
            sdk_manager_service_1.SdkManager.init({ token });
            cli_utils_1.CLIUtils.done(jsonFlag);
            cli_utils_1.CLIUtils.clearPreviousLine(jsonFlag);
        }
        catch (error) {
            const err = error;
            cli_utils_1.CLIUtils.catchError({
                error: err,
                command: Command.id,
                logReporter: this.log.bind(this),
                jsonFlag,
            });
            opts.context.exit(1);
        }
    }
};
exports.default = hook;
