import { Command } from '@oclif/core';
export default class WebDAVConfig extends Command {
    static readonly args: {};
    static readonly description = "Edit the configuration of the Internxt CLI WebDav server as the port or the protocol.";
    static readonly aliases: never[];
    static readonly examples: string[];
    static readonly flags: {
        host: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        port: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        https: import("@oclif/core/lib/interfaces").BooleanFlag<boolean>;
        http: import("@oclif/core/lib/interfaces").BooleanFlag<boolean>;
        timeout: import("@oclif/core/lib/interfaces").OptionFlag<number | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        createFullPath: import("@oclif/core/lib/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        config: import("../types/command.types").WebdavConfig;
    }>;
    catch: (error: Error) => Promise<never>;
}
