import { Command } from '@oclif/core';
export default class UploadFile extends Command {
    static readonly args: {};
    static readonly description = "Upload a file to Internxt Drive";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        file: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        destination: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/lib/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        file: {
            plainName: string;
            name: string;
            id: number;
            uuid: string;
            bucket: string;
            folderUuid: string;
            folderId: number;
            status: "EXISTS" | "TRASHED" | "DELETED";
            fileId: string;
            itemType: "file";
            size: number;
            createdAt: Date;
            updatedAt: Date;
            creationTime: Date;
            modificationTime: Date;
            type?: string | null;
        };
    }>;
    catch: (error: Error) => Promise<never>;
    private getDestinationFolderUuid;
    private getFilePath;
}
