import { Command } from '@oclif/core';
export default class TrashFolder extends Command {
    static readonly args: {};
    static readonly description = "Moves a given folder to the trash.";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        id: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/lib/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        folder: {
            uuid: string;
        };
    }>;
    catch: (error: Error) => Promise<never>;
    private getFolderUuid;
}
