import { Command } from '@oclif/core';
export default class RenameFolder extends Command {
    static readonly args: {};
    static readonly description = "Rename a folder.";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        id: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        name: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/lib/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        folder: {
            uuid: string;
            plainName: string;
        };
    }>;
    catch: (error: Error) => Promise<never>;
    private getFolderUuid;
    private getFolderName;
}
