import { Command } from '@oclif/core';
export default class MoveFolder extends Command {
    static readonly args: {};
    static readonly description = "Move a folder into a destination folder.";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        id: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        destination: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/lib/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        folder: import("@internxt/sdk/dist/drive/storage/types").FolderMeta;
    }>;
    catch: (error: Error) => Promise<never>;
    private getFolderUuid;
    private getDestinationFolderUuid;
}
