"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const config_service_1 = require("../services/config.service");
const cli_utils_1 = require("../utils/cli.utils");
class Logs extends core_1.Command {
    static args = {};
    static description = 'Displays the Internxt CLI logs directory path';
    static aliases = [];
    static examples = ['<%= config.bin %> <%= command.id %>'];
    static flags = {};
    static enableJsonFlag = true;
    run = async () => {
        const message = `Internxt CLI logs are located at ${config_service_1.ConfigService.INTERNXT_CLI_LOGS_DIR}`;
        cli_utils_1.CLIUtils.log(this.log.bind(this), message);
        return { success: true, message, path: config_service_1.ConfigService.INTERNXT_CLI_LOGS_DIR };
    };
    catch = async (error) => {
        const { flags } = await this.parse(Logs);
        cli_utils_1.CLIUtils.catchError({
            error,
            command: this.id,
            logReporter: this.log.bind(this),
            jsonFlag: flags['json'],
        });
        this.exit(1);
    };
}
exports.default = Logs;
