"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const config_service_1 = require("../services/config.service");
const cli_utils_1 = require("../utils/cli.utils");
const auth_service_1 = require("../services/auth.service");
class Logout extends core_1.Command {
    static args = {};
    static description = 'Logs out the current internxt user that is logged into the Internxt CLI.';
    static aliases = [];
    static examples = ['<%= config.bin %> <%= command.id %>'];
    static flags = {};
    static enableJsonFlag = true;
    run = async () => {
        const user = await config_service_1.ConfigService.instance.readUser();
        if (user) {
            await auth_service_1.AuthService.instance.logout();
            await config_service_1.ConfigService.instance.clearUser();
            const message = 'User logged out successfully.';
            cli_utils_1.CLIUtils.success(this.log.bind(this), message);
            return { success: true, message };
        }
        else {
            const message = 'No user is currently logged in.';
            cli_utils_1.CLIUtils.error(this.log.bind(this), message);
            return { success: false, message };
        }
    };
    catch = async (error) => {
        const { flags } = await this.parse(Logout);
        cli_utils_1.CLIUtils.catchError({
            error,
            command: this.id,
            logReporter: this.log.bind(this),
            jsonFlag: flags['json'],
        });
        this.exit(1);
    };
}
exports.default = Logout;
