import { Command } from '@oclif/core';
export default class CreateFolder extends Command {
    static readonly args: {};
    static readonly description = "Create a folder in your Internxt Drive";
    static readonly aliases: never[];
    static readonly examples: string[];
    static readonly flags: {
        name: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        id: import("@oclif/core/lib/interfaces").OptionFlag<string | undefined, import("@oclif/core/lib/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/lib/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        folder: import("@internxt/sdk/dist/drive/storage/types").CreateFolderResponse;
    }>;
    catch: (error: Error) => Promise<never>;
    private getFolderName;
    private getFolderUuid;
}
