"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const config_service_1 = require("../services/config.service");
const cli_utils_1 = require("../utils/cli.utils");
const usage_service_1 = require("../services/usage.service");
const format_utils_1 = require("../utils/format.utils");
class Config extends core_1.Command {
    static args = {};
    static description = 'Display useful information from the user logged into the Internxt CLI.';
    static aliases = [];
    static examples = ['<%= config.bin %> <%= command.id %>'];
    static flags = {};
    static enableJsonFlag = true;
    run = async () => {
        const userCredentials = await config_service_1.ConfigService.instance.readUser();
        if (userCredentials?.user) {
            const usedSpace = format_utils_1.FormatUtils.humanFileSize((await usage_service_1.UsageService.instance.fetchUsage()).total);
            const availableSpace = format_utils_1.FormatUtils.formatLimit(await usage_service_1.UsageService.instance.fetchSpaceLimit());
            const configList = [
                { key: 'Email', value: userCredentials.user.email },
                { key: 'Root folder ID', value: userCredentials.user.rootFolderId },
                { key: 'Used space', value: usedSpace },
                { key: 'Available space', value: availableSpace },
            ];
            const header = [
                { value: 'key', alias: 'Key' },
                { value: 'value', alias: 'Value' },
            ];
            cli_utils_1.CLIUtils.table(this.log.bind(this), header, configList);
            return { success: true, config: Object.fromEntries(configList.map(({ key, value }) => [key, value])) };
        }
        else {
            const message = 'You are not logged in.';
            cli_utils_1.CLIUtils.error(this.log.bind(this), message);
            return { success: false, message };
        }
    };
    catch = async (error) => {
        const { flags } = await this.parse(Config);
        cli_utils_1.CLIUtils.catchError({
            error,
            command: this.id,
            logReporter: this.log.bind(this),
            jsonFlag: flags['json'],
        });
        this.exit(1);
    };
}
exports.default = Config;
