"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const child_process_1 = require("child_process");
const config_service_1 = require("../services/config.service");
const node_os_1 = __importDefault(require("node:os"));
const node_path_1 = __importDefault(require("node:path"));
const cli_utils_1 = require("../utils/cli.utils");
class AddCert extends core_1.Command {
    static args = {};
    static description = 'Add a self-signed certificate to the trusted store for macOS, Linux, and Windows.';
    static aliases = [];
    static examples = ['<%= config.bin %> <%= command.id %>'];
    static flags = {};
    static enableJsonFlag = true;
    run = async () => {
        const certPath = node_path_1.default.join(config_service_1.ConfigService.WEBDAV_SSL_CERTS_DIR, 'cert.crt');
        const platform = node_os_1.default.platform();
        const scriptBasePath = node_path_1.default.join(__dirname, '../../scripts');
        let command = '';
        if (platform === 'win32') {
            command = `powershell -ExecutionPolicy Bypass -File "${node_path_1.default.join(scriptBasePath, 'add-cert.ps1')}" -certPath "${certPath}"`;
        }
        else if (platform === 'darwin' || platform === 'linux') {
            command = `bash "${node_path_1.default.join(scriptBasePath, 'add-cert.sh')}" "${certPath}"`;
        }
        else {
            throw new Error(`Unsupported OS: ${platform}`);
        }
        await this.executeCommand(command);
        const message = 'Certificate successfully added to the trusted store.';
        cli_utils_1.CLIUtils.success(this.log.bind(this), message);
        return { success: true, message };
    };
    catch = async (error) => {
        const { flags } = await this.parse(AddCert);
        cli_utils_1.CLIUtils.catchError({
            error,
            command: this.id,
            logReporter: this.log.bind(this),
            jsonFlag: flags['json'],
        });
        this.exit(1);
    };
    executeCommand = (command) => {
        return new Promise((resolve, reject) => {
            (0, child_process_1.exec)(command, (error, stdout, stderr) => {
                if (error) {
                    this.log(stderr);
                    reject(error);
                }
                else {
                    this.log(stdout);
                    resolve();
                }
            });
        });
    };
}
exports.default = AddCert;
