const Store = require('electron-store');
const fs = require('fs');

class LastOpenedWorkspaces {
  constructor() {
    this.store = new Store({
      name: 'preferences',
      defaults: {}
    });
  }

  getAll() {
    return this.store.get('workspaces.lastOpenedWorkspaces', []);
  }

  add(workspacePath) {
    const workspaces = this.getAll();

    if (workspaces.includes(workspacePath)) {
      return workspaces;
    }

    workspaces.unshift(workspacePath);
    this.store.set('workspaces.lastOpenedWorkspaces', workspaces);
    try {
      fs.chmodSync(this.store.path, 0o600);
    } catch (error) {
      console.error('Error setting file permissions:', error);
    }
    return workspaces;
  }

  remove(workspacePath) {
    const workspaces = this.getAll();
    const filteredWorkspaces = workspaces.filter((w) => w !== workspacePath);
    this.store.set('workspaces.lastOpenedWorkspaces', filteredWorkspaces);
    try {
      fs.chmodSync(this.store.path, 0o600);
    } catch (error) {
      console.error('Error setting file permissions:', error);
    }
    return filteredWorkspaces;
  }
}

module.exports = LastOpenedWorkspaces;
