const _ = require('lodash');
const Store = require('electron-store');
const fs = require('fs');

class CollectionSecurityStore {
  constructor() {
    this.store = new Store({
      name: 'collection-security',
      clearInvalidConfig: true
    });
  }

  setSecurityConfigForCollection(collectionPathname, securityConfig) {
    const collections = this.store.get('collections') || [];
    const collection = _.find(collections, (c) => c.path === collectionPathname);

    if (!collection) {
      collections.push({
        path: collectionPathname,
        securityConfig: {
          jsSandboxMode: securityConfig.jsSandboxMode
        }
      });

      this.store.set('collections', collections);
      try {
        fs.chmodSync(store.path, 0o600);
      } catch (error) {
        console.error('Error setting file permissions:', error);
      }
      return;
    }

    collection.securityConfig = securityConfig || {};
    this.store.set('collections', collections);
    try {
      fs.chmodSync(store.path, 0o600);
    } catch (error) {
      console.error('Error setting file permissions:', error);
    }
  }

  getSecurityConfigForCollection(collectionPathname) {
    const collections = this.store.get('collections') || [];
    const collection = _.find(collections, (c) => c.path === collectionPathname);
    return collection?.securityConfig || {};
  }
}

module.exports = CollectionSecurityStore;
