'use strict';

// --------------------------------------------------------------------
// Imports
// --------------------------------------------------------------------

const common = require('./common');
const pexprs = require('./pexprs-main');

// --------------------------------------------------------------------
// Operations
// --------------------------------------------------------------------

/*
  Return true if we should skip spaces preceding this expression in a syntactic context.
*/
pexprs.PExpr.prototype.allowsSkippingPrecedingSpace = common.abstract(
    'allowsSkippingPrecedingSpace'
);

/*
  Generally, these are all first-order expressions and (with the exception of Apply)
  directly read from the input stream.
*/
pexprs.any.allowsSkippingPrecedingSpace =
  pexprs.end.allowsSkippingPrecedingSpace =
  pexprs.Apply.prototype.allowsSkippingPrecedingSpace =
  pexprs.Terminal.prototype.allowsSkippingPrecedingSpace =
  pexprs.Range.prototype.allowsSkippingPrecedingSpace =
  pexprs.UnicodeChar.prototype.allowsSkippingPrecedingSpace =
    function() {
      return true;
    };

/*
  Higher-order expressions that don't directly consume input.
*/
pexprs.Alt.prototype.allowsSkippingPrecedingSpace =
  pexprs.Iter.prototype.allowsSkippingPrecedingSpace =
  pexprs.Lex.prototype.allowsSkippingPrecedingSpace =
  pexprs.Lookahead.prototype.allowsSkippingPrecedingSpace =
  pexprs.Not.prototype.allowsSkippingPrecedingSpace =
  pexprs.Param.prototype.allowsSkippingPrecedingSpace =
  pexprs.Seq.prototype.allowsSkippingPrecedingSpace =
    function() {
      return false;
    };
