"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.systemCertsAsync = exports.systemCertsSync = void 0;
const impl_1 = require("./impl");
const tls_1 = require("tls");
function maybeAddNodeCertificates(certs, opts) {
    if (opts.includeNodeCertificates) {
        for (const cert of tls_1.rootCertificates) {
            certs.add(cert);
        }
    }
    return [...certs];
}
function systemCertsSync(opts = {}) {
    var _a;
    let certs;
    if (process.platform === 'win32') {
        certs = new Set((0, impl_1.windowsSyncImpl)());
    }
    else if (process.platform === 'darwin') {
        certs = new Set((0, impl_1.macosSyncImpl)());
    }
    else {
        certs = new Set((0, impl_1.unixSyncImpl)((_a = opts.env) !== null && _a !== void 0 ? _a : process.env));
    }
    return maybeAddNodeCertificates(certs, opts);
}
exports.systemCertsSync = systemCertsSync;
async function systemCertsAsync(opts = {}) {
    var _a;
    const certs = new Set();
    if (process.platform === 'win32') {
        for await (const cert of (0, impl_1.windowsAsyncImpl)()) {
            certs.add(cert);
        }
    }
    else if (process.platform === 'darwin') {
        for await (const cert of (0, impl_1.macosAsyncImpl)()) {
            certs.add(cert);
        }
    }
    else {
        for await (const cert of (0, impl_1.unixAsyncImpl)((_a = opts.env) !== null && _a !== void 0 ? _a : process.env)) {
            certs.add(cert);
        }
    }
    return maybeAddNodeCertificates(certs, opts);
}
exports.systemCertsAsync = systemCertsAsync;
//# sourceMappingURL=index.js.map