"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const grpc = require("@grpc/grpc-js");
const proto_loader_1 = require("@grpc/proto-loader");
const path_1 = require("path");
jest.mock('./packageObjectHelper', () => {
    const originalModule = jest.requireActual('./packageObjectHelper');
    originalModule.packageObjectHelper = jest.fn().mockImplementation((options) => {
        const packageDefinition = (0, proto_loader_1.loadSync)((0, path_1.join)(__dirname, `../../tests/protos/${options['proto_filename']}`), options.protoLoaderOptions);
        return grpc.loadPackageDefinition(packageDefinition);
    });
    return Object.assign({ __esModule: true }, originalModule);
});
const serviceHelper_1 = require("./serviceHelper");
describe("Test Helpers", () => {
    it('Should return grpc service for addressbook', (done) => {
        (0, serviceHelper_1.serviceHelper)({
            host: "localhost:545f4",
            servicePath: "addressbook.AddressesService",
            credentials: grpc.ChannelCredentials.createInsecure(),
            proto_filename: 'addressbook.proto',
            protoLoaderOptions: {
                keepCase: true
            }
        }).then(d => {
            expect(d['Add']).toBeDefined();
            done();
        });
    });
    it('Should return grpc service for helloworld', (done) => {
        (0, serviceHelper_1.serviceHelper)({
            host: "localhost:545f4",
            servicePath: "helloworld.Greeter",
            credentials: grpc.ChannelCredentials.createInsecure(),
            proto_filename: 'helloworld.proto',
            protoLoaderOptions: {
                keepCase: true
            }
        }).then(proto => {
            expect(proto['SayHello']).toBeDefined();
            done();
        });
    });
    it('Should raise exception on wrong servicePath', (done) => {
        (0, serviceHelper_1.serviceHelper)({
            host: "localhost:545f4",
            servicePath: "addressbook.WrongServiceName",
            credentials: grpc.ChannelCredentials.createInsecure(),
            proto_filename: 'addressbook.proto',
            protoLoaderOptions: {
                keepCase: true
            }
        }).catch(e => {
            expect(e.message).toContain('Wrong servicePath');
            done();
        });
    });
    it('Should raise exception on wrong servicePath #2', (done) => {
        (0, serviceHelper_1.serviceHelper)({
            host: "localhost:545f4",
            servicePath: "addressbook.AddressesService.WrongServicename",
            credentials: grpc.ChannelCredentials.createInsecure(),
            proto_filename: 'addressbook.proto',
            protoLoaderOptions: {
                keepCase: true
            }
        }).catch(e => {
            expect(e.message).toContain('Wrong servicePath addressbook.AddressesService.WrongServicename');
            done();
        });
    });
});
//# sourceMappingURL=serviceHelper.spec.js.map