"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serviceHelper = void 0;
const packageObjectHelper_1 = require("./packageObjectHelper");
const serviceHelper = async (options) => {
    const packageObject = await (0, packageObjectHelper_1.packageObjectHelper)(options);
    const pathToService = options.servicePath.split('.');
    let service = packageObject;
    let concatenatePath = [];
    do {
        const servicePath = pathToService.shift();
        concatenatePath.push(servicePath);
        if (!(servicePath in service))
            throw new Error(`Wrong servicePath ${concatenatePath.join('.')} do not exists in packageObject. Try method: listServices in GrpcReflection class to list all services in grpc server`);
        service = service[servicePath];
    } while (pathToService.length > 0);
    return new service(options.host, options.credentials);
};
exports.serviceHelper = serviceHelper;
//# sourceMappingURL=serviceHelper.js.map