"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.packageObjectHelper = void 0;
const GrpcReflection_1 = require("../GrpcReflection");
const packageObjectHelper = async (options) => {
    const client = new GrpcReflection_1.GrpcReflection(options.host, options.credentials);
    const descriptor = 'proto_filename' in options
        ? await client.getDescriptorByFileName(options.proto_filename)
        : await client.getDescriptorBySymbol(options.proto_symbol);
    return descriptor.getPackageObject(options.protoLoaderOptions);
};
exports.packageObjectHelper = packageObjectHelper;
//# sourceMappingURL=packageObjectHelper.js.map