"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Descriptor = void 0;
const descriptor_1 = require("protobufjs/ext/descriptor");
const protoLoader = require("@grpc/proto-loader");
const grpc = require("@grpc/grpc-js");
class Descriptor {
    constructor(protoBufJsRoot) {
        this.root = protoBufJsRoot;
    }
    getProtobufJsRoot() {
        return this.root;
    }
    getDescriptorMessage(protoVersion = "proto3") {
        return this.root.toDescriptor(protoVersion);
    }
    getBuffer(protoVersion = "proto3") {
        return descriptor_1.FileDescriptorSet.encode(this.getDescriptorMessage(protoVersion)).finish();
    }
    getPackageDefinition(options, protoVersion = "proto3") {
        return protoLoader.loadFileDescriptorSetFromObject(this.getDescriptorMessage(protoVersion), options);
    }
    getPackageObject(options) {
        return grpc.loadPackageDefinition(this.getPackageDefinition(options));
    }
}
exports.Descriptor = Descriptor;
//# sourceMappingURL=Descriptor.js.map