/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.utils;

import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.awt.Graphics2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public final class SvgOverlayUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SvgOverlayUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overlaySvgOnPage(PDDocument document, PDPage page, byte[] svgBytes, float x, float y) throws IOException {
        try {
            SVGDocument svgDoc;
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(svgBytes);){
                svgDoc = factory.createSVGDocument("file:///overlay.svg", (InputStream)inputStream);
            }
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            ctx.setDynamicState(2);
            GVTBuilder builder = new GVTBuilder();
            GraphicsNode rootNode = builder.build(ctx, (Document)svgDoc);
            float svgWidth = (float)ctx.getDocumentSize().getWidth();
            float svgHeight = (float)ctx.getDocumentSize().getHeight();
            PdfBoxGraphics2D pdfGraphics = new PdfBoxGraphics2D(document, svgWidth, svgHeight);
            try {
                rootNode.paint((Graphics2D)pdfGraphics);
            }
            finally {
                pdfGraphics.dispose();
            }
            PDFormXObject xform = pdfGraphics.getXFormObject();
            try (PDPageContentStream newContentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                newContentStream.saveGraphicsState();
                newContentStream.transform(new Matrix(1.0f, 0.0f, 0.0f, 1.0f, x, y));
                newContentStream.drawForm(xform);
                newContentStream.restoreGraphicsState();
            }
            log.info("SVG successfully overlaid as vector graphic at ({}, {})", (Object)Float.valueOf(x), (Object)Float.valueOf(y));
        }
        catch (Exception e) {
            log.error("Failed to overlay SVG as vector graphic", (Throwable)e);
            throw new IOException("SVG overlay failed: " + e.getMessage(), e);
        }
    }

    public static boolean isSvgImage(byte[] bytes) {
        if (bytes == null || bytes.length < 5) {
            return false;
        }
        String start = new String(bytes, 0, Math.min(200, bytes.length), StandardCharsets.UTF_8).toLowerCase();
        return start.contains("<svg") || start.contains("<?xml") && start.contains("svg");
    }

    @Generated
    private SvgOverlayUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

