/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson.type3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import stirling.software.SPDF.model.json.PdfJsonFontConversionCandidate;
import stirling.software.SPDF.model.json.PdfJsonFontConversionStatus;
import stirling.software.SPDF.service.pdfjson.type3.Type3ConversionRequest;
import stirling.software.SPDF.service.pdfjson.type3.Type3ConversionStrategy;
import stirling.software.SPDF.service.pdfjson.type3.Type3GlyphContext;
import stirling.software.SPDF.service.pdfjson.type3.Type3GlyphExtractor;

@Service
public class Type3FontConversionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Type3FontConversionService.class);
    private final List<Type3ConversionStrategy> strategies;
    private final Type3GlyphExtractor glyphExtractor;

    public List<PdfJsonFontConversionCandidate> synthesize(Type3ConversionRequest request) {
        if (request == null || request.getFont() == null) {
            return Collections.emptyList();
        }
        if (this.strategies == null || this.strategies.isEmpty()) {
            log.debug("[TYPE3] No conversion strategies registered for font {}", (Object)request.getFontId());
            return Collections.emptyList();
        }
        ArrayList<PdfJsonFontConversionCandidate> candidates = new ArrayList<PdfJsonFontConversionCandidate>();
        Type3GlyphContext glyphContext = null;
        for (Type3ConversionStrategy strategy : this.strategies) {
            PdfJsonFontConversionCandidate candidate;
            if (strategy == null || (candidate = this.runStrategy(strategy, request, glyphContext == null ? new Type3GlyphContext(request, this.glyphExtractor) : glyphContext)) == null) continue;
            candidates.add(candidate);
        }
        return candidates;
    }

    private PdfJsonFontConversionCandidate runStrategy(Type3ConversionStrategy strategy, Type3ConversionRequest request, Type3GlyphContext glyphContext) {
        if (!strategy.isAvailable()) {
            return PdfJsonFontConversionCandidate.builder().strategyId(strategy.getId()).strategyLabel(strategy.getLabel()).status(PdfJsonFontConversionStatus.SKIPPED).message("Strategy unavailable on current host").build();
        }
        try {
            if (!strategy.supports(request, glyphContext)) {
                return PdfJsonFontConversionCandidate.builder().strategyId(strategy.getId()).strategyLabel(strategy.getLabel()).status(PdfJsonFontConversionStatus.UNSUPPORTED).message("Font not supported by strategy").build();
            }
        }
        catch (IOException supportCheckException) {
            log.warn("[TYPE3] Strategy {} support check failed for font {}: {}", new Object[]{strategy.getId(), request.getFontUid(), supportCheckException.getMessage(), supportCheckException});
            return PdfJsonFontConversionCandidate.builder().strategyId(strategy.getId()).strategyLabel(strategy.getLabel()).status(PdfJsonFontConversionStatus.UNSUPPORTED).message("Support check failed: " + supportCheckException.getMessage()).build();
        }
        try {
            PdfJsonFontConversionCandidate result = strategy.convert(request, glyphContext);
            if (result == null) {
                log.info("[TYPE3] Strategy {} returned null result for font {}", (Object)strategy.getId(), (Object)request.getFontUid());
                return PdfJsonFontConversionCandidate.builder().strategyId(strategy.getId()).strategyLabel(strategy.getLabel()).status(PdfJsonFontConversionStatus.FAILURE).message("Strategy returned null result").build();
            }
            if (result.getStrategyId() == null) {
                result.setStrategyId(strategy.getId());
            }
            if (result.getStrategyLabel() == null) {
                result.setStrategyLabel(strategy.getLabel());
            }
            log.debug("[TYPE3] Strategy {} finished with status {} (message: {}) for font {}", new Object[]{strategy.getId(), result.getStatus(), result.getMessage(), request.getFontUid()});
            return result;
        }
        catch (IOException ex) {
            log.warn("[TYPE3] Strategy {} failed for font {}: {}", new Object[]{strategy.getId(), request.getFontUid(), ex.getMessage(), ex});
            return PdfJsonFontConversionCandidate.builder().strategyId(strategy.getId()).strategyLabel(strategy.getLabel()).status(PdfJsonFontConversionStatus.FAILURE).message(ex.getMessage()).build();
        }
    }

    @Generated
    public Type3FontConversionService(List<Type3ConversionStrategy> strategies, Type3GlyphExtractor glyphExtractor) {
        this.strategies = strategies;
        this.glyphExtractor = glyphExtractor;
    }
}

