/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api.converters;

import io.swagger.v3.oas.annotations.Operation;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.MarkdownConversionResponse;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.util.PDFToFile;
import stirling.software.common.util.TempFileManager;

@ConvertApi
public class ConvertPDFToMarkdown {
    private final TempFileManager tempFileManager;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf/markdown"})
    @MarkdownConversionResponse
    @Operation(summary="Convert PDF to Markdown", description="This endpoint converts a PDF file to Markdown format. Input:PDF Output:Markdown Type:SISO")
    public ResponseEntity<byte[]> processPdfToMarkdown(@ModelAttribute PDFFile file) throws Exception {
        MultipartFile inputFile = file.getFileInput();
        PDFToFile pdfToFile = new PDFToFile(this.tempFileManager);
        return pdfToFile.processPdfToMarkdown(inputFile);
    }

    @Generated
    public ConvertPDFToMarkdown(TempFileManager tempFileManager) {
        this.tempFileManager = tempFileManager;
    }
}

