/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.util.GeneralUtils;

public class PDFWithPageNums
extends PDFFile {
    @Schema(description="The pages to select, Supports ranges (e.g., '1,3,5-9'), or 'all' or functions in the format 'an+b' where 'a' is the multiplier of the page number 'n', and 'b' is a constant (e.g., '2n+1', '3n', '6n-5')", defaultValue="all", requiredMode=Schema.RequiredMode.REQUIRED)
    private String pageNumbers;

    @Hidden
    public List<Integer> getPageNumbersList(PDDocument doc, boolean oneBased) {
        int pageCount = doc.getNumberOfPages();
        return GeneralUtils.parsePageList((String)this.pageNumbers, (int)pageCount, (boolean)oneBased);
    }

    @Generated
    public PDFWithPageNums() {
    }

    @Generated
    public String getPageNumbers() {
        return this.pageNumbers;
    }

    @Generated
    public void setPageNumbers(String pageNumbers) {
        this.pageNumbers = pageNumbers;
    }

    @Generated
    public String toString() {
        return "PDFWithPageNums(pageNumbers=" + this.getPageNumbers() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PDFWithPageNums)) {
            return false;
        }
        PDFWithPageNums other = (PDFWithPageNums)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pageNumbers = this.getPageNumbers();
        String other$pageNumbers = other.getPageNumbers();
        return !(this$pageNumbers == null ? other$pageNumbers != null : !this$pageNumbers.equals(other$pageNumbers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PDFWithPageNums;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pageNumbers = this.getPageNumbers();
        result = result * 59 + ($pageNumbers == null ? 43 : $pageNumbers.hashCode());
        return result;
    }
}

