/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import io.swagger.v3.oas.annotations.Operation;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.JsonDataResponse;
import stirling.software.SPDF.model.api.security.SignatureValidationRequest;
import stirling.software.SPDF.model.api.security.SignatureValidationResult;
import stirling.software.SPDF.service.CertificateValidationService;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.SecurityApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;

@SecurityApi
public class ValidateSignatureController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateSignatureController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final CertificateValidationService certValidationService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(MultipartFile.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @JsonDataResponse
    @Operation(summary="Validate PDF Digital Signature", description="Validates the digital signatures in a PDF file using PKIX path building and time-of-signing semantics. Supports custom trust anchors. Input:PDF Output:JSON Type:SISO")
    @AutoJobPostMapping(value={"/validate-signature"}, consumes={"multipart/form-data"})
    public ResponseEntity<List<SignatureValidationResult>> validateSignature(@ModelAttribute SignatureValidationRequest request) throws IOException {
        ArrayList<SignatureValidationResult> results = new ArrayList<SignatureValidationResult>();
        MultipartFile file = request.getFileInput();
        X509Certificate customCert = null;
        if (request.getCertFile() != null && !request.getCertFile().isEmpty()) {
            try (ByteArrayInputStream certStream = new ByteArrayInputStream(request.getCertFile().getBytes());){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                customCert = (X509Certificate)cf.generateCertificate(certStream);
            }
            catch (CertificateException e) {
                throw ExceptionUtils.createRuntimeException((String)"error.invalidFormat", (String)"Invalid {0} format: {1}", (Exception)e, (Object[])new Object[]{"certificate file", e.getMessage()});
            }
        }
        try (PDDocument document = this.pdfDocumentFactory.load(file.getInputStream());){
            List signatures = document.getSignatureDictionaries();
            for (PDSignature sig : signatures) {
                SignatureValidationResult result = new SignatureValidationResult();
                try {
                    byte[] signedContent = sig.getSignedContent(file.getInputStream());
                    byte[] signatureBytes = sig.getContents(file.getInputStream());
                    CMSProcessableByteArray content = new CMSProcessableByteArray(signedContent);
                    CMSSignedData signedData = new CMSSignedData((CMSProcessable)content, signatureBytes);
                    Store certStore = signedData.getCertificates();
                    SignerInformationStore signerStore = signedData.getSignerInfos();
                    for (SignerInformation signerInfo : signerStore.getSigners()) {
                        Date validationTime;
                        X509CertificateHolder certHolder = (X509CertificateHolder)certStore.getMatches((Selector)signerInfo.getSID()).iterator().next();
                        X509Certificate signerCert = new JcaX509CertificateConverter().getCertificate(certHolder);
                        Collection intermediates = this.certValidationService.extractIntermediateCertificates(certStore, signerCert);
                        log.debug("Found {} intermediate certificates in CMS signature", (Object)intermediates.size());
                        for (X509Certificate inter : intermediates) {
                            log.debug("  \u2192 Intermediate: {}", (Object)inter.getSubjectX500Principal().getName());
                            log.debug("    Issuer DN: {}", (Object)inter.getIssuerX500Principal().getName());
                        }
                        CertificateValidationService.ValidationTime validationTimeResult = this.certValidationService.extractValidationTime(signerInfo);
                        if (validationTimeResult == null) {
                            validationTime = new Date();
                            result.setValidationTimeSource("current");
                        } else {
                            validationTime = validationTimeResult.date;
                            result.setValidationTimeSource(validationTimeResult.source);
                        }
                        boolean cmsValid = signerInfo.verify(new JcaSimpleSignerInfoVerifierBuilder().build(signerCert));
                        result.setValid(cmsValid);
                        boolean chainValid = false;
                        boolean trustValid = false;
                        try {
                            PKIXCertPathBuilderResult pathResult = this.certValidationService.buildAndValidatePath(signerCert, intermediates, customCert, validationTime);
                            chainValid = true;
                            trustValid = true;
                            result.setCertPathLength(pathResult.getCertPath().getCertificates().size());
                        }
                        catch (Exception e) {
                            String errorMsg = e.getMessage();
                            result.setChainValidationError(errorMsg);
                            chainValid = false;
                            trustValid = false;
                            log.warn("Certificate path validation failed for {}: {}", (Object)signerCert.getSubjectX500Principal().getName(), (Object)errorMsg);
                            log.debug("Full stack trace:", (Throwable)e);
                        }
                        result.setChainValid(chainValid);
                        result.setTrustValid(trustValid);
                        boolean outside = this.certValidationService.isOutsideValidityPeriod(signerCert, validationTime);
                        result.setNotExpired(!outside);
                        boolean revocationEnabled = this.certValidationService.isRevocationEnabled();
                        result.setRevocationChecked(revocationEnabled);
                        if (!revocationEnabled) {
                            result.setRevocationStatus("not-checked");
                        } else if (chainValid && trustValid) {
                            result.setRevocationStatus("good");
                        } else if (result.getChainValidationError() != null && result.getChainValidationError().toLowerCase().contains("revocation")) {
                            if (result.getChainValidationError().toLowerCase().contains("unable to check")) {
                                result.setRevocationStatus("soft-fail");
                            } else {
                                result.setRevocationStatus("revoked");
                            }
                        } else {
                            result.setRevocationStatus("unknown");
                        }
                        result.setSignerName(sig.getName());
                        result.setSignatureDate(sig.getSignDate() != null ? sig.getSignDate().getTime().toString() : null);
                        result.setReason(sig.getReason());
                        result.setLocation(sig.getLocation());
                        result.setIssuerDN(signerCert.getIssuerX500Principal().getName());
                        result.setSubjectDN(signerCert.getSubjectX500Principal().getName());
                        result.setSerialNumber(signerCert.getSerialNumber().toString(16));
                        result.setValidFrom(signerCert.getNotBefore().toString());
                        result.setValidUntil(signerCert.getNotAfter().toString());
                        result.setSignatureAlgorithm(signerCert.getSigAlgName());
                        try {
                            result.setKeySize(((RSAPublicKey)signerCert.getPublicKey()).getModulus().bitLength());
                        }
                        catch (Exception e) {
                            result.setKeySize(0);
                        }
                        result.setVersion(String.valueOf(signerCert.getVersion()));
                        ArrayList<String> keyUsages = new ArrayList<String>();
                        boolean[] keyUsageFlags = signerCert.getKeyUsage();
                        if (keyUsageFlags != null) {
                            String[] keyUsageLabels = new String[]{"Digital Signature", "Non-Repudiation", "Key Encipherment", "Data Encipherment", "Key Agreement", "Certificate Signing", "CRL Signing", "Encipher Only", "Decipher Only"};
                            for (int i = 0; i < keyUsageFlags.length; ++i) {
                                if (!keyUsageFlags[i]) continue;
                                keyUsages.add(keyUsageLabels[i]);
                            }
                        }
                        result.setKeyUsages(keyUsages);
                        result.setSelfSigned(this.certValidationService.isSelfSigned(signerCert));
                    }
                }
                catch (Exception e) {
                    result.setValid(false);
                    result.setErrorMessage("Signature validation failed: " + e.getMessage());
                }
                results.add(result);
            }
        }
        return ResponseEntity.ok(results);
    }

    @Generated
    public ValidateSignatureController(CustomPDFDocumentFactory pdfDocumentFactory, CertificateValidationService certValidationService) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.certValidationService = certValidationService;
    }
}

