/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.misc.AddStampRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class StampController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;
    private static final int MAX_DATE_FORMAT_LENGTH = 50;
    private static final Pattern SAFE_DATE_FORMAT_PATTERN = Pattern.compile("^[yMdHhmsS/\\-:\\s.,'+EGuwWDFzZXa]+$");
    private static final Pattern CUSTOM_DATE_PATTERN = Pattern.compile("@date\\{([^}]{1,50})\\}");
    private static final String ESCAPED_AT_PLACEHOLDER = "\ue000ESCAPED_AT\ue000";

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(MultipartFile.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/add-stamp"})
    @Operation(summary="Add stamp to a PDF file", description="This endpoint adds a stamp to a given PDF file. Users can specify the stamp type (text or image), rotation, opacity, width spacer, and height spacer. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> addStamp(@ModelAttribute AddStampRequest request) throws IOException, Exception {
        MultipartFile pdfFile = request.getFileInput();
        String pdfFileName = pdfFile.getOriginalFilename();
        if (pdfFileName.contains("..") || pdfFileName.startsWith("/")) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.invalid.filepath", (String)("Invalid PDF file path: " + pdfFileName), (Object[])new Object[0]);
        }
        String stampType = request.getStampType();
        String stampText = request.getStampText();
        MultipartFile stampImage = request.getStampImage();
        if ("image".equalsIgnoreCase(stampType)) {
            if (stampImage == null) {
                throw ExceptionUtils.createIllegalArgumentException((String)"error.stamp.image.required", (String)"Stamp image file must be provided when stamp type is 'image'", (Object[])new Object[0]);
            }
            String stampImageName = stampImage.getOriginalFilename();
            if (stampImageName == null || stampImageName.contains("..") || stampImageName.startsWith("/")) {
                throw ExceptionUtils.createIllegalArgumentException((String)"error.invalidFormat", (String)"Invalid {0} format: {1}", (Object[])new Object[]{"stamp image file path", stampImageName});
            }
        }
        String alphabet = request.getAlphabet();
        float fontSize = request.getFontSize();
        float rotation = request.getRotation();
        float opacity = request.getOpacity();
        int position = request.getPosition();
        float overrideX = request.getOverrideX();
        float overrideY = request.getOverrideY();
        String customColor = request.getCustomColor();
        float marginFactor = switch (request.getCustomMargin().toLowerCase(Locale.ROOT)) {
            case "small" -> 0.02f;
            case "medium" -> 0.035f;
            case "large" -> 0.05f;
            case "x-large" -> 0.075f;
            default -> 0.035f;
        };
        try (PDDocument document = this.pdfDocumentFactory.load(pdfFile);){
            List pageNumbers = request.getPageNumbersList(document, true);
            ResponseEntity responseEntity = pageNumbers.iterator();
            while (responseEntity.hasNext()) {
                int pageIndex = (Integer)responseEntity.next();
                int zeroBasedIndex = pageIndex - 1;
                if (zeroBasedIndex < 0 || zeroBasedIndex >= document.getNumberOfPages()) continue;
                PDPage page = document.getPage(zeroBasedIndex);
                PDRectangle pageSize = page.getMediaBox();
                float margin = marginFactor * (pageSize.getWidth() + pageSize.getHeight()) / 2.0f;
                PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
                PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
                graphicsState.setNonStrokingAlphaConstant(Float.valueOf(opacity));
                contentStream.setGraphicsStateParameters(graphicsState);
                if ("text".equalsIgnoreCase(stampType)) {
                    this.addTextStamp(contentStream, stampText, document, page, rotation, position, fontSize, alphabet, overrideX, overrideY, margin, customColor, pageIndex, pdfFileName);
                } else if ("image".equalsIgnoreCase(stampType)) {
                    this.addImageStamp(contentStream, stampImage, document, page, rotation, position, fontSize, overrideX, overrideY, margin);
                }
                contentStream.close();
            }
            responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)pdfFile.getOriginalFilename(), (String)"_stamped.pdf"));
            return responseEntity;
        }
    }

    private void addTextStamp(PDPageContentStream contentStream, String stampText, PDDocument document, PDPage page, float rotation, int position, float fontSize, String alphabet, float overrideX, float overrideY, float margin, String colorString, int currentPageNumber, String filename) throws IOException {
        float y;
        float x;
        Color redactColor;
        PDType1Font font = new PDType1Font(Standard14Fonts.FontName.HELVETICA);
        String resourceDir = switch (alphabet) {
            case "arabic" -> "static/fonts/NotoSansArabic-Regular.ttf";
            case "japanese" -> "static/fonts/Meiryo.ttf";
            case "korean" -> "static/fonts/malgun.ttf";
            case "chinese" -> "static/fonts/SimSun.ttf";
            case "thai" -> "static/fonts/NotoSansThai-Regular.ttf";
            case "roman" -> "static/fonts/NotoSans-Regular.ttf";
            default -> "static/fonts/NotoSans-Regular.ttf";
        };
        ClassPathResource classPathResource = new ClassPathResource(resourceDir);
        String fileExtension = resourceDir.substring(resourceDir.lastIndexOf("."));
        try (TempFile tempFileWrapper = new TempFile(this.tempFileManager, fileExtension);){
            File tempFile = tempFileWrapper.getFile();
            try (InputStream is = classPathResource.getInputStream();
                 FileOutputStream os = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
                font = PDType0Font.load((PDDocument)document, (File)tempFile);
            }
        }
        try {
            if (!((String)colorString).startsWith("#")) {
                colorString = "#" + (String)colorString;
            }
            redactColor = Color.decode((String)colorString);
        }
        catch (NumberFormatException e) {
            redactColor = Color.LIGHT_GRAY;
        }
        contentStream.setNonStrokingColor(redactColor);
        int pageCount = document.getNumberOfPages();
        String processedStampText = this.processStampText(stampText, currentPageNumber, pageCount, filename, document);
        String normalizedText = RegexPatternUtils.getInstance().getEscapedNewlinePattern().matcher(processedStampText).replaceAll("\n");
        String[] lines = normalizedText.split("\\r?\\n");
        PDRectangle pageSize = page.getMediaBox();
        float effectiveFontSize = fontSize > 0.0f ? fontSize : 40.0f;
        contentStream.setFont((PDFont)font, effectiveFontSize);
        float ascent = font.getFontDescriptor().getAscent();
        float descent = font.getFontDescriptor().getDescent();
        float lineHeight = (ascent - descent) / 1000.0f * effectiveFontSize;
        float maxLineWidth = 0.0f;
        for (String line : lines) {
            float lineWidth = this.calculateTextWidth(line, (PDFont)font, effectiveFontSize);
            if (!(lineWidth > maxLineWidth)) continue;
            maxLineWidth = lineWidth;
        }
        float totalTextHeight = (float)lines.length * lineHeight;
        if (overrideX >= 0.0f && overrideY >= 0.0f) {
            x = overrideX;
            y = overrideY;
        } else {
            x = this.calculatePositionX(pageSize, position, maxLineWidth, margin);
            y = this.calculatePositionY(pageSize, position, totalTextHeight, margin);
        }
        contentStream.beginText();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            contentStream.setTextMatrix(Matrix.getRotateInstance((double)Math.toRadians(rotation), (float)x, (float)(y - (float)i * lineHeight)));
            contentStream.showText(line);
        }
        contentStream.endText();
    }

    private String processStampText(String stampText, int currentPageNumber, int totalPages, String filename, PDDocument document) {
        int lastDot;
        String filenameWithoutExt;
        if (stampText == null || stampText.isEmpty()) {
            return "";
        }
        String result = stampText.replace("@@", ESCAPED_AT_PLACEHOLDER);
        LocalDateTime now = LocalDateTime.now();
        String currentDate = now.toLocalDate().toString();
        String currentTime = now.toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        String currentDateTime = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String string = filenameWithoutExt = filename != null ? filename : "";
        if (filename != null && filename.contains(".") && (lastDot = filename.lastIndexOf(46)) > 0) {
            filenameWithoutExt = filename.substring(0, lastDot);
        }
        String author = "";
        String title = "";
        String subject = "";
        if (document != null && document.getDocumentInformation() != null) {
            PDDocumentInformation info = document.getDocumentInformation();
            author = info.getAuthor() != null ? info.getAuthor() : "";
            title = info.getTitle() != null ? info.getTitle() : "";
            subject = info.getSubject() != null ? info.getSubject() : "";
        }
        String uuid = UUID.randomUUID().toString().substring(0, 8);
        Matcher matcher = CUSTOM_DATE_PATTERN.matcher(result);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String format = matcher.group(1);
            String replacement = this.processCustomDateFormat(format, now);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        result = sb.toString();
        result = result.replace("@datetime", currentDateTime).replace("@date", currentDate).replace("@time", currentTime).replace("@year", String.valueOf(now.getYear())).replace("@month", String.format("%02d", now.getMonthValue())).replace("@day", String.format("%02d", now.getDayOfMonth())).replace("@page_number", String.valueOf(currentPageNumber)).replace("@page_count", String.valueOf(totalPages)).replace("@total_pages", String.valueOf(totalPages)).replace("@page", String.valueOf(currentPageNumber)).replace("@filename_full", filename != null ? filename : "").replace("@filename", filenameWithoutExt).replace("@author", author).replace("@title", title).replace("@subject", subject).replace("@uuid", uuid);
        result = result.replace(ESCAPED_AT_PLACEHOLDER, "@");
        return result;
    }

    private String processCustomDateFormat(String format, LocalDateTime now) {
        if (format == null || format.length() > 50) {
            return "[invalid format: too long]";
        }
        if (!SAFE_DATE_FORMAT_PATTERN.matcher(format).matches()) {
            return "[invalid format]";
        }
        try {
            return now.format(DateTimeFormatter.ofPattern(format));
        }
        catch (IllegalArgumentException e) {
            return "[invalid format: " + format + "]";
        }
    }

    private void addImageStamp(PDPageContentStream contentStream, MultipartFile stampImage, PDDocument document, PDPage page, float rotation, int position, float fontSize, float overrideX, float overrideY, float margin) throws IOException {
        float y;
        float x;
        BufferedImage image = ImageIO.read(stampImage.getInputStream());
        float aspectRatio = (float)image.getWidth() / (float)image.getHeight();
        float desiredPhysicalHeight = fontSize;
        float desiredPhysicalWidth = desiredPhysicalHeight * aspectRatio;
        PDImageXObject xobject = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)image);
        PDRectangle pageSize = page.getMediaBox();
        if (overrideX >= 0.0f && overrideY >= 0.0f) {
            x = overrideX;
            y = overrideY;
        } else {
            x = this.calculatePositionX(pageSize, position, desiredPhysicalWidth, margin);
            y = this.calculatePositionY(pageSize, position, desiredPhysicalHeight, margin);
        }
        contentStream.saveGraphicsState();
        contentStream.transform(Matrix.getTranslateInstance((float)x, (float)y));
        contentStream.transform(Matrix.getRotateInstance((double)Math.toRadians(rotation), (float)0.0f, (float)0.0f));
        contentStream.drawImage(xobject, 0.0f, 0.0f, desiredPhysicalWidth, desiredPhysicalHeight);
        contentStream.restoreGraphicsState();
    }

    private float calculatePositionX(PDRectangle pageSize, int position, float contentWidth, float margin) {
        return switch (position % 3) {
            case 1 -> pageSize.getLowerLeftX() + margin;
            case 2 -> (pageSize.getWidth() - contentWidth) / 2.0f;
            case 0 -> pageSize.getUpperRightX() - contentWidth - margin;
            default -> 0.0f;
        };
    }

    private float calculatePositionY(PDRectangle pageSize, int position, float height, float margin) {
        return switch ((position - 1) / 3) {
            case 0 -> pageSize.getUpperRightY() - margin;
            case 1 -> (pageSize.getHeight() + height) / 2.0f;
            case 2 -> pageSize.getLowerLeftY() + margin + height;
            default -> 0.0f;
        };
    }

    private float calculateTextWidth(String text, PDFont font, float fontSize) throws IOException {
        return font.getStringWidth(text) / 1000.0f * fontSize;
    }

    @Generated
    public StampController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
    }
}

