/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.model.api.converters.PdfVectorExportRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@ConvertApi
public class PdfVectorExportController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfVectorExportController.class);
    private static final MediaType PDF_MEDIA_TYPE = MediaType.APPLICATION_PDF;
    private static final Set<String> GHOSTSCRIPT_INPUTS = Set.of("ps", "eps", "epsf");
    private final TempFileManager tempFileManager;
    private final EndpointConfiguration endpointConfiguration;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/vector/pdf"})
    @Operation(summary="Convert PostScript formats to PDF", description="Converts PostScript vector inputs (PS, EPS, EPSF) to PDF using Ghostscript. Input:PS/EPS Output:PDF Type:SISO")
    public ResponseEntity<byte[]> convertGhostscriptInputsToPdf(@Valid @ModelAttribute PdfVectorExportRequest request) throws Exception {
        String originalName = request.getFileInput() != null ? request.getFileInput().getOriginalFilename() : null;
        String extension = originalName != null ? FilenameUtils.getExtension((String)originalName).toLowerCase(Locale.ROOT) : "";
        try (TempFile inputTemp = new TempFile(this.tempFileManager, (String)(extension.isEmpty() ? "" : "." + extension));){
            ResponseEntity responseEntity;
            try (TempFile outputTemp = new TempFile(this.tempFileManager, ".pdf");){
                request.getFileInput().transferTo(inputTemp.getFile());
                if (GHOSTSCRIPT_INPUTS.contains(extension)) {
                    boolean prepress = request.getPrepress() != null && request.getPrepress() != false;
                    this.runGhostscriptToPdf(inputTemp.getPath(), outputTemp.getPath(), prepress);
                } else if ("pdf".equals(extension)) {
                    Files.copy(inputTemp.getPath(), outputTemp.getPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    throw ExceptionUtils.createIllegalArgumentException((String)"error.invalidFormat", (String)"Unsupported Ghostscript input format {0}", (Object[])new Object[]{extension});
                }
                byte[] pdfBytes = Files.readAllBytes(outputTemp.getPath());
                String outputName = GeneralUtils.generateFilename((String)originalName, (String)"_converted.pdf");
                responseEntity = WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)outputName, (MediaType)PDF_MEDIA_TYPE);
            }
            return responseEntity;
        }
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf/vector"})
    @Operation(summary="Convert PDF to vector format", description="Converts PDF to Ghostscript vector formats (EPS, PS, PCL, or XPS). Input:PDF Output:VECTOR Type:SISO")
    public ResponseEntity<byte[]> convertPdfToVector(@Valid @ModelAttribute PdfVectorExportRequest request) throws Exception {
        String originalName = request.getFileInput() != null ? request.getFileInput().getOriginalFilename() : null;
        String outputFormat = request.getOutputFormat();
        if (outputFormat == null || outputFormat.isEmpty()) {
            outputFormat = "eps";
        }
        outputFormat = outputFormat.toLowerCase(Locale.ROOT);
        try (TempFile inputTemp = new TempFile(this.tempFileManager, ".pdf");){
            String string;
            try (TempFile outputTemp = new TempFile(this.tempFileManager, "." + outputFormat);){
                request.getFileInput().transferTo(inputTemp.getFile());
                this.runGhostscriptPdfToVector(inputTemp.getPath(), outputTemp.getPath(), outputFormat);
                byte[] vectorBytes = Files.readAllBytes(outputTemp.getPath());
                String outputName = GeneralUtils.generateFilename((String)originalName, (String)("_converted." + outputFormat));
                string = WebResponseUtils.bytesToWebResponse((byte[])vectorBytes, (String)outputName, (MediaType)(switch (outputFormat.toLowerCase(Locale.ROOT)) {
                    case "eps", "ps" -> MediaType.parseMediaType((String)"application/postscript");
                    case "pcl" -> MediaType.parseMediaType((String)"application/vnd.hp-PCL");
                    case "xps" -> MediaType.parseMediaType((String)"application/vnd.ms-xpsdocument");
                    default -> MediaType.APPLICATION_OCTET_STREAM;
                }));
            }
            return string;
        }
    }

    private void runGhostscriptPdfToVector(Path inputPath, Path outputPath, String outputFormat) throws IOException, InterruptedException {
        if (!this.endpointConfiguration.isGroupEnabled("Ghostscript")) {
            throw ExceptionUtils.createGhostscriptConversionException((String)outputFormat);
        }
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("gs");
        String device = switch (outputFormat.toLowerCase(Locale.ROOT)) {
            case "eps" -> "eps2write";
            case "ps" -> "ps2write";
            case "pcl" -> "pxlcolor";
            case "xps" -> "xpswrite";
            default -> throw ExceptionUtils.createIllegalArgumentException((String)"error.invalidFormat", (String)"Unsupported output format: {0}", (Object[])new Object[]{outputFormat});
        };
        command.add("-sDEVICE=" + device);
        command.add("-dNOPAUSE");
        command.add("-dBATCH");
        command.add("-dSAFER");
        command.add("-sOutputFile=" + String.valueOf(outputPath.toAbsolutePath()));
        command.add(inputPath.toAbsolutePath().toString());
        log.debug("Executing Ghostscript command: {}", (Object)String.join((CharSequence)" ", command));
        ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(command);
        ExceptionUtils.GhostscriptException criticalError = ExceptionUtils.detectGhostscriptCriticalError((String)result.getMessages());
        if (criticalError != null) {
            log.error("Ghostscript PDF to {} conversion detected critical error: {}. Command: {}", new Object[]{outputFormat.toUpperCase(), criticalError.getMessage(), String.join((CharSequence)" ", command)});
            throw criticalError;
        }
        if (result.getRc() != 0) {
            log.error("Ghostscript PDF to {} conversion failed with rc={} and messages={}. Command: {}", new Object[]{outputFormat.toUpperCase(), result.getRc(), result.getMessages(), String.join((CharSequence)" ", command)});
            throw ExceptionUtils.createGhostscriptConversionException((String)outputFormat);
        }
    }

    private void runGhostscriptToPdf(Path inputPath, Path outputPath, boolean prepress) throws IOException, InterruptedException {
        if (!this.endpointConfiguration.isGroupEnabled("Ghostscript")) {
            throw ExceptionUtils.createGhostscriptConversionException((String)"pdfwrite");
        }
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("gs");
        command.add("-sDEVICE=pdfwrite");
        command.add("-dNOPAUSE");
        command.add("-dBATCH");
        command.add("-dSAFER");
        command.add("-dCompatibilityLevel=1.4");
        if (prepress) {
            command.add("-dPDFSETTINGS=/prepress");
        }
        command.add("-sOutputFile=" + String.valueOf(outputPath.toAbsolutePath()));
        command.add(inputPath.toAbsolutePath().toString());
        log.debug("Executing Ghostscript PostScript-to-PDF command: {}", (Object)String.join((CharSequence)" ", command));
        ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(command);
        ExceptionUtils.GhostscriptException criticalError = ExceptionUtils.detectGhostscriptCriticalError((String)result.getMessages());
        if (criticalError != null) {
            log.error("Ghostscript PostScript-to-PDF conversion detected critical error: {}. Command: {}", (Object)criticalError.getMessage(), (Object)String.join((CharSequence)" ", command));
            throw criticalError;
        }
        if (result.getRc() != 0) {
            log.error("Ghostscript PostScript-to-PDF conversion failed with rc={} and messages={}. Command: {}", new Object[]{result.getRc(), result.getMessages(), String.join((CharSequence)" ", command)});
            throw ExceptionUtils.createGhostscriptConversionException((String)"pdfwrite");
        }
    }

    @Generated
    public PdfVectorExportController(TempFileManager tempFileManager, EndpointConfiguration endpointConfiguration) {
        this.tempFileManager = tempFileManager;
        this.endpointConfiguration = endpointConfiguration;
    }
}

