/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import stirling.software.SPDF.config.swagger.CsvConversionResponse;
import stirling.software.SPDF.controller.api.converters.ExtractCSVController;
import stirling.software.SPDF.model.api.PDFWithPageNums;
import stirling.software.SPDF.pdf.FlexibleCSVWriter;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import technology.tabula.ObjectExtractor;
import technology.tabula.Page;
import technology.tabula.Table;
import technology.tabula.extractors.SpreadsheetExtractionAlgorithm;

@ConvertApi
public class ExtractCSVController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtractCSVController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(value={"/pdf/csv"}, consumes={"multipart/form-data"})
    @CsvConversionResponse
    @Operation(summary="Extracts a CSV document from a PDF", description="This operation takes an input PDF file and returns CSV file of whole page. Input:PDF Output:CSV Type:SISO")
    public ResponseEntity<?> pdfToCsv(@ModelAttribute PDFWithPageNums request) throws Exception {
        String baseName = this.getBaseName(request.getFileInput().getOriginalFilename());
        ArrayList<CsvEntry> csvEntries = new ArrayList<CsvEntry>();
        try (PDDocument document = this.pdfDocumentFactory.load((PDFFile)request);){
            List pages = request.getPageNumbersList(document, true);
            SpreadsheetExtractionAlgorithm sea = new SpreadsheetExtractionAlgorithm();
            CSVFormat format = CSVFormat.EXCEL.builder().setEscape('\"').setQuoteMode(QuoteMode.ALL).build();
            ResponseEntity responseEntity = pages.iterator();
            while (responseEntity.hasNext()) {
                int pageNum = (Integer)responseEntity.next();
                try (ObjectExtractor extractor = new ObjectExtractor(document);){
                    log.info("{}", (Object)pageNum);
                    Page page = extractor.extract(pageNum);
                    List tables = sea.extract(page);
                    for (int i = 0; i < tables.size(); ++i) {
                        StringWriter sw = new StringWriter();
                        FlexibleCSVWriter csvWriter = new FlexibleCSVWriter(format);
                        csvWriter.write((Appendable)sw, Collections.singletonList((Table)tables.get(i)));
                        String entryName = this.generateEntryName(baseName, pageNum, i + 1);
                        csvEntries.add(new CsvEntry(entryName, sw.toString()));
                    }
                }
            }
            if (csvEntries.isEmpty()) {
                responseEntity = ResponseEntity.noContent().build();
                return responseEntity;
            }
            if (csvEntries.size() == 1) {
                responseEntity = this.createCsvResponse((CsvEntry)csvEntries.get(0), baseName);
                return responseEntity;
            }
            responseEntity = this.createZipResponse(csvEntries, baseName);
            return responseEntity;
        }
    }

    private ResponseEntity<byte[]> createZipResponse(List<CsvEntry> entries, String baseName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zipOut = new ZipOutputStream(baos);){
            for (CsvEntry entry : entries) {
                ZipEntry zipEntry = new ZipEntry(entry.filename());
                zipOut.putNextEntry(zipEntry);
                zipOut.write(entry.content().getBytes(StandardCharsets.UTF_8));
                zipOut.closeEntry();
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDisposition(ContentDisposition.builder((String)"attachment").filename(baseName + "_extracted.zip").build());
        headers.setContentType(MediaType.parseMediaType((String)"application/zip"));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)baos.toByteArray());
    }

    private ResponseEntity<String> createCsvResponse(CsvEntry entry, String baseName) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDisposition(ContentDisposition.builder((String)"attachment").filename(baseName + "_extracted.csv").build());
        headers.setContentType(MediaType.parseMediaType((String)"text/csv"));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)entry.content());
    }

    private String generateEntryName(String baseName, int pageNum, int tableIndex) {
        return String.format(Locale.ROOT, "%s_p%d_t%d.csv", baseName, pageNum, tableIndex);
    }

    private String getBaseName(String filename) {
        return GeneralUtils.removeExtension((String)filename);
    }

    @Generated
    public ExtractCSVController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

