/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.swagger.v3.oas.annotations.Operation;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import stirling.software.SPDF.model.api.converters.PdfToVideoRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ApplicationContextProvider;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;

@ConvertApi
public class ConvertPdfToVideoController {
    private static final Set<String> SUPPORTED_FORMATS = Set.of("mp4", "webm");
    private static final Map<String, String> RESOLUTION_FILTERS = Map.of("ORIGINAL", "scale=trunc(iw/2)*2:trunc(ih/2)*2,setsar=1", "1080P", "scale=-2:1080,setsar=1", "720P", "scale=-2:720,setsar=1", "480P", "scale=-2:480,setsar=1");
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;

    /*
     * Exception decompiling
     */
    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf/video"})
    @Operation(summary="Convert PDF to Video Slideshow", description="This endpoint converts a PDF document into a slideshow-style video. Input:PDF Output:Video Type:SISO")
    public ResponseEntity<byte[]> convertPdfToVideo(@ModelAttribute PdfToVideoRequest request) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateFrames(Path inputPdf, Path outputDir, int dpi, float opacity, String watermarkText, boolean isWatermarkEnabled) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load(inputPdf.toFile());){
            PDFRenderer renderer = new PDFRenderer(document);
            renderer.setSubsamplingAllowed(true);
            int pageCount = document.getNumberOfPages();
            if (pageCount == 0) {
                throw ExceptionUtils.createIllegalArgumentException((String)"error.invalidFormat", (String)"Invalid {0} format: {1}", (Object[])new Object[]{"PDF", "no pages"});
            }
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                int currentPageIndex = pageIndex;
                ExceptionUtils.validateRenderingDimensions((PDPage)document.getPage(currentPageIndex), (int)(currentPageIndex + 1), (int)dpi);
                BufferedImage image = (BufferedImage)ExceptionUtils.handleOomRendering((int)(currentPageIndex + 1), (int)dpi, () -> renderer.renderImageWithDPI(currentPageIndex, (float)dpi, ImageType.RGB));
                if (isWatermarkEnabled) {
                    this.applyWatermark(image, opacity, watermarkText);
                }
                Path framePath = outputDir.resolve(String.format(Locale.ROOT, "frame_%05d.png", pageIndex + 1));
                ImageIO.write((RenderedImage)image, "png", framePath.toFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyWatermark(BufferedImage image, float opacity, String watermarkText) {
        Graphics2D graphics = image.createGraphics();
        try {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int baseDimension = Math.min(image.getWidth(), image.getHeight());
            int fontSize = Math.max(32, baseDimension / 5);
            Font font = new Font("SansSerif", 1, fontSize);
            graphics.setFont(font);
            FontMetrics metrics = graphics.getFontMetrics(font);
            int textWidth = metrics.stringWidth(watermarkText);
            int textHeight = metrics.getAscent();
            AffineTransform originalTransform = graphics.getTransform();
            double angle = Math.atan2(image.getHeight(), image.getWidth());
            graphics.translate((double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
            graphics.rotate(-angle);
            graphics.setComposite(AlphaComposite.getInstance(3, opacity / 2.0f));
            graphics.setColor(Color.BLACK);
            graphics.drawString(watermarkText, (float)(-textWidth) / 2.0f + 3.0f, (float)textHeight / 2.0f + 3.0f);
            graphics.setComposite(AlphaComposite.getInstance(3, opacity));
            graphics.setColor(Color.WHITE);
            graphics.drawString(watermarkText, (float)(-textWidth) / 2.0f, (float)textHeight / 2.0f);
            graphics.setTransform(originalTransform);
        }
        finally {
            graphics.dispose();
        }
    }

    private List<String> buildFfmpegCommand(String format, String resolution, String frameRate, TempFile outputVideo) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("ffmpeg");
        command.add("-y");
        command.add("-framerate");
        command.add(frameRate);
        command.add("-i");
        command.add("frame_%05d.png");
        command.add("-vf");
        command.add(RESOLUTION_FILTERS.getOrDefault(resolution, (String)RESOLUTION_FILTERS.get("ORIGINAL")));
        if ("mp4".equals(format)) {
            command.addAll(List.of("-c:v", "libx264", "-pix_fmt", "yuv420p", "-movflags", "+faststart"));
        } else if ("webm".equals(format)) {
            command.addAll(List.of("-c:v", "libvpx-vp9", "-b:v", "0", "-crf", "30"));
        }
        command.add(outputVideo.getAbsolutePath());
        return command;
    }

    private String normalizeFormat(String requestedFormat) {
        String format;
        String string = format = requestedFormat != null ? requestedFormat.toLowerCase(Locale.ROOT) : "mp4";
        if (!SUPPORTED_FORMATS.contains(format)) {
            format = "mp4";
        }
        return format;
    }

    private int getMaxDpi() {
        ApplicationProperties properties = (ApplicationProperties)ApplicationContextProvider.getBean(ApplicationProperties.class);
        if (properties != null && properties.getSystem() != null) {
            return properties.getSystem().getMaxDPI();
        }
        return 500;
    }

    private MediaType getMediaType(String format) {
        return switch (format) {
            case "webm" -> MediaType.valueOf((String)"video/webm");
            default -> MediaType.valueOf((String)"video/mp4");
        };
    }

    @Generated
    public ConvertPdfToVideoController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
    }
}

