/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.json.PdfJsonDocument;
import stirling.software.SPDF.model.json.PdfJsonMetadata;
import stirling.software.SPDF.service.PdfJsonConversionService;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.model.api.GeneralFile;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.JobOwnershipService;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.WebResponseUtils;

@ConvertApi
public class ConvertPdfJsonController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertPdfJsonController.class);
    private final PdfJsonConversionService pdfJsonConversionService;
    @Autowired(required=false)
    private JobOwnershipService jobOwnershipService;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf/text-editor"})
    @Operation(summary="Convert PDF to Text Editor Format", description="Extracts PDF text, fonts, and metadata into an editable JSON structure for the text editor tool. Input:PDF Output:JSON Type:SISO")
    public ResponseEntity<byte[]> convertPdfToJson(@ModelAttribute PDFFile request, @RequestParam(value="lightweight", defaultValue="false") boolean lightweight) throws Exception {
        MultipartFile inputFile = request.getFileInput();
        if (inputFile == null) {
            throw ExceptionUtils.createNullArgumentException((String)"fileInput");
        }
        byte[] jsonBytes = this.pdfJsonConversionService.convertPdfToJson(inputFile, lightweight);
        String originalName = inputFile.getOriginalFilename();
        String baseName = originalName != null && !originalName.isBlank() ? Filenames.toSimpleFileName((String)originalName).replaceFirst("[.][^.]+$", "") : "document";
        String docName = baseName + ".json";
        return WebResponseUtils.bytesToWebResponse((byte[])jsonBytes, (String)docName, (MediaType)MediaType.APPLICATION_JSON);
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/text-editor/pdf"})
    @StandardPdfResponse
    @Operation(summary="Convert Text Editor Format to PDF", description="Rebuilds a PDF from the editable JSON structure generated by the text editor tool. Input:JSON Output:PDF Type:SISO")
    public ResponseEntity<byte[]> convertJsonToPdf(@ModelAttribute GeneralFile request) throws Exception {
        MultipartFile jsonFile = request.getFileInput();
        if (jsonFile == null) {
            throw ExceptionUtils.createNullArgumentException((String)"fileInput");
        }
        byte[] pdfBytes = this.pdfJsonConversionService.convertJsonToPdf(jsonFile);
        String originalName = jsonFile.getOriginalFilename();
        String baseName = originalName != null && !originalName.isBlank() ? Filenames.toSimpleFileName((String)originalName).replaceFirst("[.][^.]+$", "") : "document";
        Object docName = baseName.endsWith(".pdf") ? baseName : baseName + ".pdf";
        return WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)docName);
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf/text-editor/metadata"})
    @Operation(summary="Extract PDF metadata for text editor lazy loading", description="Extracts document metadata, fonts, and page dimensions for the text editor tool. Caches the document for subsequent page requests. Returns a server-generated jobId scoped to the authenticated user. Input:PDF Output:JSON Type:SISO")
    public ResponseEntity<byte[]> extractPdfMetadata(@ModelAttribute PDFFile request) throws Exception {
        MultipartFile inputFile = request.getFileInput();
        if (inputFile == null) {
            throw ExceptionUtils.createNullArgumentException((String)"fileInput");
        }
        String baseJobId = UUID.randomUUID().toString();
        String scopedJobKey = this.getScopedJobKey(baseJobId);
        log.info("Extracting metadata for PDF, assigned jobId: {}", (Object)scopedJobKey);
        byte[] jsonBytes = this.pdfJsonConversionService.extractDocumentMetadata(inputFile, scopedJobKey);
        String originalName = inputFile.getOriginalFilename();
        String baseName = originalName != null && !originalName.isBlank() ? Filenames.toSimpleFileName((String)originalName).replaceFirst("[.][^.]+$", "") : "document";
        String docName = baseName + "_metadata.json";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("X-Job-Id", new String[]{scopedJobKey})).contentType(MediaType.APPLICATION_JSON).body((Object)jsonBytes);
    }

    @AutoJobPostMapping(value={"/pdf/text-editor/partial/{jobId}"}, consumes={"application/json"})
    @StandardPdfResponse
    @Operation(summary="Apply incremental edits from text editor to a cached PDF", description="Applies edits for the specified pages of a cached PDF and returns an updated PDF. Requires the PDF to have been previously cached via the text editor metadata endpoint. The jobId must be obtained from the metadata extraction endpoint.")
    public ResponseEntity<byte[]> exportPartialPdf(@PathVariable String jobId, @RequestBody PdfJsonDocument document, @RequestParam(value="filename", required=false) String filename) throws Exception {
        if (document == null) {
            throw ExceptionUtils.createNullArgumentException((String)"document");
        }
        this.validateJobAccess(jobId);
        byte[] pdfBytes = this.pdfJsonConversionService.exportUpdatedPages(jobId, document);
        String baseName = filename != null && !filename.isBlank() ? Filenames.toSimpleFileName((String)filename).replaceFirst("[.][^.]+$", "") : Optional.ofNullable(document.getMetadata()).map(PdfJsonMetadata::getTitle).filter(title -> title != null && !title.isBlank()).orElse("document");
        Object docName = baseName.endsWith(".pdf") ? baseName : baseName + ".pdf";
        return WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)docName);
    }

    @GetMapping(value={"/pdf/text-editor/page/{jobId}/{pageNumber}"})
    @Operation(summary="Extract single page from cached PDF for text editor", description="Retrieves a single page's content from a previously cached PDF document for the text editor tool. Requires prior call to /pdf/text-editor/metadata. The jobId must belong to the authenticated user. Output:JSON")
    public ResponseEntity<byte[]> extractSinglePage(@PathVariable String jobId, @PathVariable int pageNumber) throws Exception {
        this.validateJobAccess(jobId);
        byte[] jsonBytes = this.pdfJsonConversionService.extractSinglePage(jobId, pageNumber);
        String docName = "page_" + pageNumber + ".json";
        return WebResponseUtils.bytesToWebResponse((byte[])jsonBytes, (String)docName, (MediaType)MediaType.APPLICATION_JSON);
    }

    @AutoJobPostMapping(value={"/pdf/text-editor/clear-cache/{jobId}"})
    @Operation(summary="Clear cached PDF document for text editor", description="Manually clears a cached PDF document used by the text editor to free up server resources. Called automatically after 30 minutes. The jobId must belong to the authenticated user.")
    public ResponseEntity<Void> clearCache(@PathVariable String jobId) {
        this.validateJobAccess(jobId);
        this.pdfJsonConversionService.clearCachedDocument(jobId);
        return ResponseEntity.ok().build();
    }

    private String getScopedJobKey(String baseJobId) {
        if (this.jobOwnershipService != null) {
            return this.jobOwnershipService.createScopedJobKey(baseJobId);
        }
        return baseJobId;
    }

    private void validateJobAccess(String jobId) {
        if (this.jobOwnershipService != null) {
            this.jobOwnershipService.validateJobAccess(jobId);
        }
    }

    @Generated
    public ConvertPdfJsonController(PdfJsonConversionService pdfJsonConversionService) {
        this.pdfJsonConversionService = pdfJsonConversionService;
    }
}

