/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.model.api.converters.ConvertPdfToEpubRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@ConvertApi
public class ConvertPDFToEpubController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertPDFToEpubController.class);
    private static final String CALIBRE_GROUP = "Calibre";
    private static final String DEFAULT_EXTENSION = "pdf";
    private static final String FILTERED_CSS = "font-family,color,background-color,margin-left,margin-right";
    private static final String SMART_CHAPTER_EXPRESSION = "//h:*[re:test(., '\\s*Chapter\\s+', 'i')]";
    private final TempFileManager tempFileManager;
    private final EndpointConfiguration endpointConfiguration;

    private static List<String> buildCalibreCommand(Path inputPath, Path outputPath, boolean detectChapters, ConvertPdfToEpubRequest.TargetDevice targetDevice) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("ebook-convert");
        command.add(inputPath.toString());
        command.add(outputPath.toString());
        command.add("--enable-heuristics");
        command.add("--insert-blank-line");
        command.add("--filter-css");
        command.add("font-family,color,background-color,margin-left,margin-right");
        if (detectChapters) {
            command.add("--chapter");
            command.add("//h:*[re:test(., '\\s*Chapter\\s+', 'i')]");
        }
        if (targetDevice != null) {
            command.add("--output-profile");
            command.add(targetDevice.getCalibreProfile());
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf/epub"})
    @Operation(summary="Convert PDF to EPUB/AZW3", description="Convert a PDF file to a high-quality EPUB or AZW3 ebook using Calibre. Input:PDF Output:EPUB/AZW3 Type:SISO")
    public ResponseEntity<byte[]> convertPdfToEpub(@ModelAttribute ConvertPdfToEpubRequest request) throws Exception {
        ResponseEntity responseEntity;
        String extension;
        if (!this.endpointConfiguration.isGroupEnabled("Calibre")) {
            throw new IllegalStateException("Calibre support is disabled. Enable the Calibre group or install Calibre to use this feature.");
        }
        MultipartFile inputFile = request.getFileInput();
        if (inputFile == null || inputFile.isEmpty()) {
            throw new IllegalArgumentException("No input file provided");
        }
        boolean detectChapters = !Boolean.FALSE.equals(request.getDetectChapters());
        ConvertPdfToEpubRequest.TargetDevice targetDevice = request.getTargetDevice() == null ? ConvertPdfToEpubRequest.TargetDevice.TABLET_PHONE_IMAGES : request.getTargetDevice();
        ConvertPdfToEpubRequest.OutputFormat outputFormat = request.getOutputFormat() == null ? ConvertPdfToEpubRequest.OutputFormat.EPUB : request.getOutputFormat();
        String originalFilename = Filenames.toSimpleFileName((String)inputFile.getOriginalFilename());
        if (originalFilename == null || originalFilename.isBlank()) {
            originalFilename = "document.pdf";
        }
        if ((extension = FilenameUtils.getExtension((String)originalFilename)).isBlank()) {
            throw new IllegalArgumentException("Unable to determine file type");
        }
        if (!"pdf".equalsIgnoreCase(extension)) {
            throw new IllegalArgumentException("Input file must be a PDF");
        }
        String baseName = FilenameUtils.getBaseName((String)originalFilename);
        if (baseName == null || baseName.isBlank()) {
            baseName = "document";
        }
        Path workingDirectory = null;
        Path inputPath = null;
        Path outputPath = null;
        try {
            workingDirectory = this.tempFileManager.createTempDirectory();
            inputPath = workingDirectory.resolve(baseName + ".pdf");
            outputPath = workingDirectory.resolve(baseName + "." + outputFormat.getExtension());
            try (InputStream inputStream = inputFile.getInputStream();){
                Files.copy(inputStream, inputPath, StandardCopyOption.REPLACE_EXISTING);
            }
            List command = ConvertPDFToEpubController.buildCalibreCommand((Path)inputPath, (Path)outputPath, (boolean)detectChapters, (ConvertPdfToEpubRequest.TargetDevice)targetDevice);
            ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.CALIBRE).runCommandWithOutputHandling(command, workingDirectory.toFile());
            if (result == null) {
                throw new IllegalStateException("Calibre conversion returned no result");
            }
            if (result.getRc() != 0) {
                String errorMessage = result.getMessages();
                if (errorMessage == null || errorMessage.isBlank()) {
                    errorMessage = "Calibre conversion failed";
                }
                throw new IllegalStateException(errorMessage);
            }
            if (!Files.exists(outputPath, new LinkOption[0]) || Files.size(outputPath) == 0L) {
                throw new IllegalStateException("Calibre did not produce a " + outputFormat.name() + " output");
            }
            String outputFilename = GeneralUtils.generateFilename((String)originalFilename, (String)("_convertedTo" + outputFormat.name() + "." + outputFormat.getExtension()));
            byte[] outputBytes = Files.readAllBytes(outputPath);
            MediaType mediaType = MediaType.valueOf((String)outputFormat.getMediaType());
            responseEntity = WebResponseUtils.bytesToWebResponse((byte[])outputBytes, (String)outputFilename, (MediaType)mediaType);
        }
        catch (Throwable throwable) {
            this.cleanupTempFiles(workingDirectory, inputPath, outputPath);
            throw throwable;
        }
        this.cleanupTempFiles(workingDirectory, inputPath, outputPath);
        return responseEntity;
    }

    private void cleanupTempFiles(Path workingDirectory, Path inputPath, Path outputPath) {
        if (workingDirectory == null) {
            return;
        }
        ArrayList<Path> pathsToDelete = new ArrayList<Path>();
        if (inputPath != null) {
            pathsToDelete.add(inputPath);
        }
        if (outputPath != null) {
            pathsToDelete.add(outputPath);
        }
        for (Path path : pathsToDelete) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                log.warn("Failed to delete temporary file: {}", (Object)path, (Object)e);
            }
        }
        try {
            this.tempFileManager.deleteTempDirectory(workingDirectory);
        }
        catch (Exception e) {
            log.warn("Failed to delete temporary directory: {}", (Object)workingDirectory, (Object)e);
        }
    }

    @Generated
    public ConvertPDFToEpubController(TempFileManager tempFileManager, EndpointConfiguration endpointConfiguration) {
        this.tempFileManager = tempFileManager;
        this.endpointConfiguration = endpointConfiguration;
    }
}

