/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.general.MergePdfsRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.PdfErrorUtils;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@GeneralApi
public class MergeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergeController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDDocument mergeDocuments(List<PDDocument> documents) throws IOException {
        PDDocument mergedDoc = this.pdfDocumentFactory.createNewDocument();
        boolean success = false;
        try {
            for (PDDocument doc : documents) {
                for (PDPage page : doc.getPages()) {
                    mergedDoc.addPage(page);
                }
            }
            success = true;
            PDDocument pDDocument = mergedDoc;
            return pDDocument;
        }
        finally {
            if (!success) {
                mergedDoc.close();
            }
        }
    }

    private static MultipartFile[] reorderFilesByProvidedOrder(MultipartFile[] files, String fileOrder) {
        String[] desired = RegexPatternUtils.getInstance().getNewlineSplitPattern().split(fileOrder);
        ArrayList<MultipartFile> remaining = new ArrayList<MultipartFile>(Arrays.asList(files));
        ArrayList<MultipartFile> ordered = new ArrayList<MultipartFile>(files.length);
        for (String name : desired) {
            if ((name = name.trim()).isEmpty()) {
                log.debug("Skipping empty entry");
                continue;
            }
            int idx = MergeController.indexOfByOriginalFilename(remaining, (String)name);
            if (idx >= 0) {
                ordered.add((MultipartFile)remaining.remove(idx));
                continue;
            }
            log.debug("Filename from order list not found in uploaded files: {}", (Object)name);
        }
        ordered.addAll(remaining);
        return ordered.toArray(new MultipartFile[0]);
    }

    private Comparator<MultipartFile> getSortComparator(String sortType) {
        return switch (sortType) {
            case "byFileName" -> Comparator.comparing(mf -> {
                String name = mf.getOriginalFilename();
                return name == null ? "" : name;
            }, String.CASE_INSENSITIVE_ORDER);
            case "byDateModified" -> (file1, file2) -> {
                long t1 = this.getPdfDateTimeSafe(file1);
                long t2 = this.getPdfDateTimeSafe(file2);
                return Long.compare(t2, t1);
            };
            case "byDateCreated" -> (file1, file2) -> {
                long t1 = this.getPdfDateTimeSafe(file1);
                long t2 = this.getPdfDateTimeSafe(file2);
                return Long.compare(t2, t1);
            };
            case "byPDFTitle" -> (file1, file2) -> {
                try (PDDocument doc1 = this.pdfDocumentFactory.load(file1);){
                    int n;
                    block26: {
                        String title2;
                        String title1;
                        PDDocument doc2;
                        block24: {
                            int n2;
                            block25: {
                                block22: {
                                    int n3;
                                    block23: {
                                        block20: {
                                            int n4;
                                            block21: {
                                                doc2 = this.pdfDocumentFactory.load(file2);
                                                try {
                                                    title1 = doc1.getDocumentInformation() != null ? doc1.getDocumentInformation().getTitle() : null;
                                                    String string = title2 = doc2.getDocumentInformation() != null ? doc2.getDocumentInformation().getTitle() : null;
                                                    if (title1 != null || title2 != null) break block20;
                                                    n4 = 0;
                                                    if (doc2 == null) break block21;
                                                }
                                                catch (Throwable throwable) {
                                                    if (doc2 != null) {
                                                        try {
                                                            doc2.close();
                                                        }
                                                        catch (Throwable throwable2) {
                                                            throwable.addSuppressed(throwable2);
                                                        }
                                                    }
                                                    throw throwable;
                                                }
                                                doc2.close();
                                            }
                                            return n4;
                                        }
                                        if (title1 != null) break block22;
                                        n3 = 1;
                                        if (doc2 == null) break block23;
                                        doc2.close();
                                    }
                                    return n3;
                                }
                                if (title2 != null) break block24;
                                n2 = -1;
                                if (doc2 == null) break block25;
                                doc2.close();
                            }
                            return n2;
                        }
                        n = title1.compareToIgnoreCase(title2);
                        if (doc2 == null) break block26;
                        doc2.close();
                    }
                    return n;
                }
                catch (IOException e) {
                    return 0;
                }
            };
            case "orderProvided" -> (file1, file2) -> 0;
            default -> (file1, file2) -> 0;
        };
    }

    private String[] parseClientFileIds(String clientFileIds) {
        if (clientFileIds == null || clientFileIds.trim().isEmpty()) {
            return new String[0];
        }
        try {
            String trimmed = clientFileIds.trim();
            if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
                String inside = trimmed.substring(1, trimmed.length() - 1).trim();
                if (inside.isEmpty()) {
                    return new String[0];
                }
                String[] parts = inside.split(",");
                String[] result = new String[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    result[i] = parts[i].trim().replaceAll("^\"|\"$", "");
                }
                return result;
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse client file IDs: {}", (Object)clientFileIds, (Object)e);
        }
        return new String[0];
    }

    private void addTableOfContents(PDDocument mergedDocument, MultipartFile[] files) {
        PDDocumentOutline outline = new PDDocumentOutline();
        mergedDocument.getDocumentCatalog().setDocumentOutline(outline);
        int pageIndex = 0;
        for (MultipartFile file : files) {
            String filename = file.getOriginalFilename();
            String title = GeneralUtils.removeExtension((String)filename);
            PDOutlineItem item = new PDOutlineItem();
            item.setTitle(title);
            if (pageIndex < mergedDocument.getNumberOfPages()) {
                PDPage page = mergedDocument.getPage(pageIndex);
                item.setDestination(page);
            }
            outline.addLast(item);
            try (PDDocument doc = this.pdfDocumentFactory.load(file);){
                pageIndex += doc.getNumberOfPages();
            }
            catch (IOException e) {
                ExceptionUtils.logException((String)"document loading for TOC generation", (Exception)e);
                ++pageIndex;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private long getPdfDateTimeSafe(MultipartFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int indexOfByOriginalFilename(List<MultipartFile> list, String name) {
        for (int i = 0; i < list.size(); ++i) {
            MultipartFile f = list.get(i);
            if (!name.equals(f.getOriginalFilename())) continue;
            return i;
        }
        return -1;
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/merge-pdfs"})
    @StandardPdfResponse
    @Operation(summary="Merge multiple PDF files into one", description="This endpoint merges multiple PDF files into a single PDF file. The merged file will contain all pages from the input files in the order they were provided. Input:PDF Output:PDF Type:MISO")
    public ResponseEntity<byte[]> mergePdfs(@ModelAttribute MergePdfsRequest request, @RequestParam(value="fileOrder", required=false) String fileOrder) throws IOException {
        ArrayList<File> filesToDelete = new ArrayList<File>();
        TempFile outputTempFile = null;
        boolean removeCertSign = Boolean.TRUE.equals(request.getRemoveCertSign());
        boolean generateToc = request.isGenerateToc();
        MultipartFile[] files = request.getFileInput();
        if (files == null) {
            files = new MultipartFile[]{};
        }
        if (fileOrder != null && !fileOrder.isBlank()) {
            log.info("Reordering files based on fileOrder parameter");
            files = MergeController.reorderFilesByProvidedOrder((MultipartFile[])files, (String)fileOrder);
        } else {
            log.info("Sorting files based on sortType: {}", (Object)request.getSortType());
            Arrays.sort(files, this.getSortComparator(request.getSortType()));
        }
        try (TempFile mt = new TempFile(this.tempFileManager, ".pdf");){
            PDFMergerUtility mergerUtility = new PDFMergerUtility();
            long totalSize = 0L;
            ArrayList<Integer> invalidIndexes = new ArrayList<Integer>();
            for (int index = 0; index < files.length; ++index) {
                MultipartFile multipartFile = files[index];
                totalSize += multipartFile.getSize();
                File tempFile = this.tempFileManager.convertMultipartFileToFile(multipartFile);
                filesToDelete.add(tempFile);
                try {
                    PDDocument ignored = this.pdfDocumentFactory.load(multipartFile);
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                catch (IOException e) {
                    ExceptionUtils.logException((String)"PDF pre-validate", (Exception)e);
                    invalidIndexes.add(index);
                }
                mergerUtility.addSource(tempFile);
            }
            mergerUtility.setDestinationFileName(mt.getFile().getAbsolutePath());
            try {
                mergerUtility.mergeDocuments(this.pdfDocumentFactory.getStreamCacheFunction(totalSize));
            }
            catch (IOException e) {
                ExceptionUtils.logException((String)"PDF merge", (Exception)e);
                if (PdfErrorUtils.isCorruptedPdfError((IOException)e)) {
                    throw ExceptionUtils.createMultiplePdfCorruptedException((Exception)e);
                }
                throw e;
            }
            try (PDDocument mergedDocument = this.pdfDocumentFactory.load(mt.getFile());){
                PDDocumentCatalog catalog;
                PDAcroForm acroForm;
                if (removeCertSign && (acroForm = (catalog = mergedDocument.getDocumentCatalog()).getAcroForm()) != null) {
                    List<PDField> fieldsToRemove = acroForm.getFields().stream().filter(PDSignatureField.class::isInstance).toList();
                    if (!fieldsToRemove.isEmpty()) {
                        acroForm.flatten(fieldsToRemove, false);
                    }
                }
                if (generateToc && files.length > 0) {
                    this.addTableOfContents(mergedDocument, files);
                }
                outputTempFile = new TempFile(this.tempFileManager, ".pdf");
                try {
                    mergedDocument.save(outputTempFile.getFile());
                }
                catch (Exception e) {
                    outputTempFile.close();
                    outputTempFile = null;
                    throw e;
                }
            }
        }
        catch (Exception ex) {
            if (outputTempFile != null) {
                outputTempFile.close();
            }
            if (ex instanceof IOException && PdfErrorUtils.isCorruptedPdfError((IOException)((IOException)ex))) {
                log.warn("Corrupted PDF detected in merge pdf process: {}", (Object)ex.getMessage());
            } else {
                log.error("Error in merge pdf process", (Throwable)ex);
            }
            throw ex;
        }
        finally {
            for (File file : filesToDelete) {
                this.tempFileManager.deleteTempFile(file);
            }
        }
        String firstFilename = files.length > 0 ? files[0].getOriginalFilename() : null;
        String mergedFileName = GeneralUtils.generateFilename((String)firstFilename, (String)"_merged_unsigned.pdf");
        byte[] pdfBytes = Files.readAllBytes(outputTempFile.getPath());
        return WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)mergedFileName);
    }

    @Generated
    public MergeController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
    }
}

