/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.management.ManagementFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"STIRLING_PDF_TAURI_MODE"}, havingValue="true")
public class TauriProcessMonitor {
    private static final Logger logger = LoggerFactory.getLogger(TauriProcessMonitor.class);
    private final ApplicationContext applicationContext;
    private String parentProcessId;
    private ScheduledExecutorService scheduler;
    private volatile boolean monitoring = false;

    public TauriProcessMonitor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        this.parentProcessId = System.getenv("TAURI_PARENT_PID");
        if (this.parentProcessId != null && !this.parentProcessId.trim().isEmpty()) {
            logger.info("Tauri mode detected. Parent process ID: {}", (Object)this.parentProcessId);
            this.startMonitoring();
        } else {
            logger.warn("TAURI_PARENT_PID environment variable not found. Tauri process monitoring disabled.");
        }
    }

    private void startMonitoring() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "tauri-process-monitor");
            t.setDaemon(true);
            return t;
        });
        this.monitoring = true;
        this.scheduler.scheduleAtFixedRate(() -> this.checkParentProcess(), 5L, 5L, TimeUnit.SECONDS);
        logger.info("Started monitoring parent Tauri process (PID: {})", (Object)this.parentProcessId);
    }

    private void checkParentProcess() {
        if (!this.monitoring) {
            return;
        }
        try {
            if (!this.isProcessAlive(this.parentProcessId)) {
                logger.warn("Parent Tauri process (PID: {}) is no longer alive. Initiating graceful shutdown...", (Object)this.parentProcessId);
                this.initiateGracefulShutdown();
            }
        }
        catch (Exception e) {
            logger.error("Error checking parent process status", (Throwable)e);
        }
    }

    private boolean isProcessAlive(String pid) {
        try {
            long processId = Long.parseLong(pid);
            return ProcessHandle.of(processId).isPresent();
        }
        catch (NumberFormatException e) {
            logger.error("Invalid parent process ID format: {}", (Object)pid);
            return false;
        }
        catch (Exception e) {
            logger.error("Error checking if process {} is alive", (Object)pid, (Object)e);
            return false;
        }
    }

    private void initiateGracefulShutdown() {
        this.monitoring = false;
        logger.info("Orphaned Java backend detected. Shutting down gracefully...");
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(1000L);
                if (this.applicationContext instanceof ConfigurableApplicationContext) {
                    ((ConfigurableApplicationContext)this.applicationContext).close();
                } else {
                    logger.warn("Unable to shutdown Spring context gracefully, using System.exit");
                    System.exit(0);
                }
            }
            catch (Exception e) {
                logger.error("Error during graceful shutdown", (Throwable)e);
                System.exit(1);
            }
        });
    }

    @PreDestroy
    public void cleanup() {
        this.monitoring = false;
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            logger.info("Shutting down Tauri process monitor");
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static String getCurrentProcessId() {
        try {
            return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        catch (Exception e) {
            return "unknown";
        }
    }
}

