/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.config.ExternalAppDepConfig;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.util.RegexPatternUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class ExternalAppDepConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalAppDepConfig.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(5L);
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+(?:\\.\\d+){0,2})");
    private final EndpointConfiguration endpointConfiguration;
    private volatile boolean dependenciesChecked = false;
    private final boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    private final String weasyprintPath;
    private final String unoconvPath;
    private final String calibrePath;
    private final String ocrMyPdfPath;
    private final String sOfficePath;
    private final Map<String, List<String>> commandToGroupMapping;
    private final ExecutorService pool = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2));

    public ExternalAppDepConfig(EndpointConfiguration endpointConfiguration, RuntimePathConfig runtimePathConfig) {
        this.endpointConfiguration = endpointConfiguration;
        this.weasyprintPath = runtimePathConfig.getWeasyPrintPath();
        this.unoconvPath = runtimePathConfig.getUnoConvertPath();
        this.calibrePath = runtimePathConfig.getCalibrePath();
        this.ocrMyPdfPath = runtimePathConfig.getOcrMyPdfPath();
        this.sOfficePath = runtimePathConfig.getSOfficePath();
        HashMap<String, List<String>> tmp = new HashMap<String, List<String>>();
        tmp.put("gs", List.of("Ghostscript"));
        tmp.put(this.ocrMyPdfPath, List.of("OCRmyPDF"));
        tmp.put(this.sOfficePath, List.of("LibreOffice"));
        tmp.put(this.weasyprintPath, List.of("Weasyprint"));
        tmp.put("pdftohtml", List.of("Pdftohtml"));
        tmp.put(this.unoconvPath, List.of("Unoconvert"));
        tmp.put("qpdf", List.of("qpdf"));
        tmp.put("tesseract", List.of("tesseract"));
        tmp.put("rar", List.of("rar"));
        tmp.put(this.calibrePath, List.of("Calibre"));
        tmp.put("ffmpeg", List.of("FFmpeg"));
        tmp.put("magick", List.of("ImageMagick"));
        this.commandToGroupMapping = Collections.unmodifiableMap(tmp);
    }

    public boolean isDependenciesChecked() {
        return this.dependenciesChecked;
    }

    @PostConstruct
    public void checkDependencies() {
        try {
            List tasks = this.commandToGroupMapping.keySet().stream().map(cmd -> () -> {
                this.checkDependencyAndDisableGroup(cmd);
                return null;
            }).collect(Collectors.toList());
            this.invokeAllWithTimeout(tasks, DEFAULT_TIMEOUT.plusSeconds(3L));
            this.checkPythonAndOpenCV();
            this.dependenciesChecked = true;
        }
        finally {
            this.endpointConfiguration.logDisabledEndpointsSummary();
            this.pool.shutdown();
        }
    }

    private void checkDependencyAndDisableGroup(String command) {
        Optional version;
        boolean available = this.isCommandAvailable(command);
        if (!available) {
            List affectedGroups = (List)this.commandToGroupMapping.get(command);
            if (affectedGroups == null || affectedGroups.isEmpty()) {
                return;
            }
            for (String group : affectedGroups) {
                List affectedFeatures = this.getAffectedFeatures(group);
                this.endpointConfiguration.disableGroup(group, EndpointConfiguration.DisableReason.DEPENDENCY);
                log.warn("Missing dependency: {} - Disabling group: {} (Affected features: {})", new Object[]{command, group, affectedFeatures.isEmpty() ? "unknown" : String.join((CharSequence)", ", affectedFeatures)});
            }
            return;
        }
        if (this.isWeasyprint(command)) {
            version = this.getVersionSafe(command, "--version");
            version.ifPresentOrElse(v -> {
                Version installed = new Version(v);
                Version required = new Version("58.0");
                if (installed.compareTo(required) < 0) {
                    List<String> affectedGroups = this.commandToGroupMapping.getOrDefault(command, List.of("Weasyprint"));
                    for (String group : affectedGroups) {
                        this.endpointConfiguration.disableGroup(group, EndpointConfiguration.DisableReason.DEPENDENCY);
                    }
                    log.warn("WeasyPrint version {} is below required {} - disabling group(s): {}", new Object[]{installed, required, String.join((CharSequence)", ", affectedGroups)});
                } else {
                    log.info("WeasyPrint {} meets minimum {}", (Object)installed, (Object)required);
                }
            }, () -> log.warn("WeasyPrint version could not be determined ({} --version)", (Object)command));
        }
        if (this.isQpdf(command)) {
            version = this.getVersionSafe(command, "--version");
            version.ifPresentOrElse(v -> {
                Version installed = new Version(v);
                Version required = new Version("12.0.0");
                if (installed.compareTo(required) < 0) {
                    List<String> affectedGroups = this.commandToGroupMapping.getOrDefault(command, List.of("qpdf"));
                    for (String group : affectedGroups) {
                        this.endpointConfiguration.disableGroup(group, EndpointConfiguration.DisableReason.DEPENDENCY);
                    }
                    log.warn("qpdf version {} is below required {} - disabling group(s): {}", new Object[]{installed, required, String.join((CharSequence)", ", affectedGroups)});
                } else {
                    log.info("qpdf {} meets minimum {}", (Object)installed, (Object)required);
                }
            }, () -> log.warn("qpdf version could not be determined ({} --version)", (Object)command));
        }
    }

    private boolean isWeasyprint(String command) {
        return Objects.equals(command, this.weasyprintPath) || command.toLowerCase(Locale.ROOT).contains("weasyprint");
    }

    private boolean isQpdf(String command) {
        return command.toLowerCase(Locale.ROOT).contains("qpdf");
    }

    private List<String> getAffectedFeatures(String group) {
        ArrayList endpoints = new ArrayList(this.endpointConfiguration.getEndpointsForGroup(group));
        return endpoints.stream().map(arg_0 -> this.formatEndpointAsFeature(arg_0)).toList();
    }

    private String formatEndpointAsFeature(String endpoint) {
        String feature = endpoint.replace("-", " ").replace("pdf", "PDF").replace("img", "image");
        return Arrays.stream(RegexPatternUtils.getInstance().getWordSplitPattern().split(feature)).map(arg_0 -> this.capitalizeWord(arg_0)).collect(Collectors.joining(" "));
    }

    private String capitalizeWord(String word) {
        if (word == null || word.isEmpty()) {
            return word;
        }
        if ("pdf".equalsIgnoreCase(word)) {
            return "PDF";
        }
        return word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT);
    }

    private void checkPythonAndOpenCV() {
        String python = this.findFirstAvailable(List.of("python3", "python")).orElse(null);
        if (python == null) {
            this.disablePythonAndOpenCV("Python interpreter not found on PATH");
            return;
        }
        int ec = this.runAndWait(List.of(python, "-c", "import cv2"), DEFAULT_TIMEOUT).exitCode();
        if (ec != 0) {
            List openCVFeatures = this.getAffectedFeatures("OpenCV");
            this.endpointConfiguration.disableGroup("OpenCV", EndpointConfiguration.DisableReason.DEPENDENCY);
            log.warn("OpenCV not available in Python - Disabling OpenCV features: {}", (Object)String.join((CharSequence)", ", openCVFeatures));
        }
    }

    private void disablePythonAndOpenCV(String reason) {
        List pythonFeatures = this.getAffectedFeatures("Python");
        List openCVFeatures = this.getAffectedFeatures("OpenCV");
        this.endpointConfiguration.disableGroup("Python", EndpointConfiguration.DisableReason.DEPENDENCY);
        this.endpointConfiguration.disableGroup("OpenCV", EndpointConfiguration.DisableReason.DEPENDENCY);
        log.warn("Missing dependency: Python (reason: {}) - Disabling Python features: {} and OpenCV features: {}", new Object[]{reason, String.join((CharSequence)", ", pythonFeatures), String.join((CharSequence)", ", openCVFeatures)});
    }

    private Optional<String> findFirstAvailable(List<String> commands) {
        for (String c : commands) {
            if (!this.isCommandAvailable(c)) continue;
            return Optional.of(c);
        }
        return Optional.empty();
    }

    private boolean isCommandAvailable(String command) {
        List<String> lookup = this.isWindows ? List.of("where", command) : List.of("which", command);
        ProbeResult res = this.runAndWait(lookup, DEFAULT_TIMEOUT);
        if (res.exitCode() == 0) {
            return true;
        }
        ProbeResult ver = this.runAndWait(List.of(command, "--version"), DEFAULT_TIMEOUT);
        return ver.exitCode() == 0;
    }

    private Optional<String> getVersionSafe(String command, String arg) {
        try {
            ProbeResult res = this.runAndWait(List.of(command, arg), DEFAULT_TIMEOUT);
            if (res.exitCode() != 0) {
                return Optional.empty();
            }
            String text = res.combined();
            Matcher m = VERSION_PATTERN.matcher(text);
            return m.find() ? Optional.of(m.group(1)) : Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private void invokeAllWithTimeout(List<Callable<Void>> tasks, Duration timeout) {
        try {
            List<Future<Void>> futures = this.pool.invokeAll(tasks, timeout.toMillis(), TimeUnit.MILLISECONDS);
            for (Future<Void> f : futures) {
                try {
                    f.get();
                }
                catch (Exception exception) {}
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private ProbeResult runAndWait(List<String> cmd, Duration timeout) {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        try {
            Process p = pb.start();
            boolean finished = p.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (!finished) {
                p.destroyForcibly();
                return new ProbeResult(124, "", "timeout");
            }
            String out = ExternalAppDepConfig.readStream((InputStream)p.getInputStream());
            String err = ExternalAppDepConfig.readStream((InputStream)p.getErrorStream());
            int ec = p.exitValue();
            return new ProbeResult(ec, out, err);
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return new ProbeResult(127, "", String.valueOf(e.getMessage()));
        }
    }

    private static String readStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
            }
        }
        return sb.toString().trim();
    }
}

