/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF;

import io.github.pixee.security.SystemCommand;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibreOfficeListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LibreOfficeListener.class);
    private static final long ACTIVITY_TIMEOUT = 1200000L;
    private static final LibreOfficeListener INSTANCE = new LibreOfficeListener();
    private static final int LISTENER_PORT = 2002;
    private ExecutorService executorService;
    private long lastActivityTime;
    private Process process;

    private LibreOfficeListener() {
    }

    public static LibreOfficeListener getInstance() {
        return INSTANCE;
    }

    private boolean isListenerRunning() {
        boolean bl;
        log.info("waiting for listener to start");
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress("localhost", 2002), 1000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public void start() throws IOException {
        if (this.process != null && this.process.isAlive()) {
            return;
        }
        this.process = SystemCommand.runCommand((Runtime)Runtime.getRuntime(), (String)"unoconv --listener");
        this.lastActivityTime = System.currentTimeMillis();
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(() -> {
            while (true) {
                long idleTime;
                if ((idleTime = System.currentTimeMillis() - this.lastActivityTime) >= 1200000L) {
                    this.process.destroy();
                    break;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        });
        long startTime = System.currentTimeMillis();
        long timeout = 30000L;
        while (System.currentTimeMillis() - startTime < timeout) {
            if (this.isListenerRunning()) {
                this.lastActivityTime = System.currentTimeMillis();
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("exception", (Throwable)e);
            }
        }
    }

    public synchronized void stop() {
        this.executorService.shutdownNow();
        if (this.process != null && this.process.isAlive()) {
            this.process.destroy();
        }
    }
}

