/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson.type3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.util.Matrix;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Type3FontSignatureCalculator {
    private Type3FontSignatureCalculator() {
    }

    public static String computeSignature(PDType3Font font) throws IOException {
        if (font == null) {
            return null;
        }
        MessageDigest digest = Type3FontSignatureCalculator.newDigest();
        Type3FontSignatureCalculator.updateMatrix((MessageDigest)digest, (Matrix)font.getFontMatrix());
        Type3FontSignatureCalculator.updateRectangle((MessageDigest)digest, (PDRectangle)font.getFontBBox());
        Type3FontSignatureCalculator.updateEncoding((MessageDigest)digest, (Encoding)font.getEncoding());
        Type3FontSignatureCalculator.updateCharProcs((MessageDigest)digest, (PDType3Font)font);
        byte[] hash = digest.digest();
        return "sha256:" + Type3FontSignatureCalculator.toHex((byte[])hash);
    }

    private static void updateEncoding(MessageDigest digest, Encoding encoding) {
        if (encoding == null) {
            Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)-1);
            return;
        }
        for (int code = 0; code <= 255; ++code) {
            String name = encoding.getName(code);
            if (name == null) continue;
            Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)code);
            Type3FontSignatureCalculator.updateString((MessageDigest)digest, (String)name);
        }
    }

    private static void updateCharProcs(MessageDigest digest, PDType3Font font) throws IOException {
        COSDictionary charProcs = (COSDictionary)font.getCOSObject().getDictionaryObject(COSName.CHAR_PROCS);
        if (charProcs == null || charProcs.size() == 0) {
            Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)0);
            return;
        }
        ArrayList<COSName> glyphNames = new ArrayList<COSName>(charProcs.keySet());
        glyphNames.sort(Comparator.comparing(COSName::getName, String.CASE_INSENSITIVE_ORDER));
        for (COSName glyphName : glyphNames) {
            COSStream cosStream;
            COSStream stream;
            Type3FontSignatureCalculator.updateString((MessageDigest)digest, (String)glyphName.getName());
            int code = Type3FontSignatureCalculator.resolveCharCode((PDType3Font)font, (String)glyphName.getName());
            Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)code);
            if (code >= 0) {
                try {
                    Type3FontSignatureCalculator.updateFloat((MessageDigest)digest, (float)font.getWidthFromFont(code));
                }
                catch (IOException ignored) {
                    Type3FontSignatureCalculator.updateFloat((MessageDigest)digest, (float)0.0f);
                }
            } else {
                Type3FontSignatureCalculator.updateFloat((MessageDigest)digest, (float)0.0f);
            }
            COSBase cOSBase = charProcs.getDictionaryObject(glyphName);
            COSStream cOSStream = stream = cOSBase instanceof COSStream ? (cosStream = (COSStream)cOSBase) : null;
            if (stream != null) {
                byte[] payload = Type3FontSignatureCalculator.readAllBytes((COSStream)stream);
                Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)payload.length);
                digest.update(payload);
                PDType3CharProc charProc = new PDType3CharProc(font, stream);
                Type3FontSignatureCalculator.updateRectangle((MessageDigest)digest, (COSArray)Type3FontSignatureCalculator.extractGlyphBoundingBox((PDType3Font)font, (PDType3CharProc)charProc));
                continue;
            }
            Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)-1);
        }
        Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)glyphNames.size());
    }

    private static byte[] readAllBytes(COSStream stream) throws IOException {
        try (COSInputStream inputStream = stream.createInputStream();){
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
    }

    private static COSArray extractGlyphBoundingBox(PDType3Font font, PDType3CharProc charProc) {
        COSArray bboxArray;
        if (charProc == null) {
            return null;
        }
        COSStream stream = charProc.getCOSObject();
        if (stream != null && (bboxArray = (COSArray)stream.getDictionaryObject(COSName.BBOX)) != null && bboxArray.size() == 4) {
            return bboxArray;
        }
        return font.getCOSObject().getCOSArray(COSName.BBOX);
    }

    private static int resolveCharCode(PDType3Font font, String glyphName) {
        if (glyphName == null || font.getEncoding() == null) {
            return -1;
        }
        Encoding encoding = font.getEncoding();
        for (int code = 0; code <= 255; ++code) {
            String name = encoding.getName(code);
            if (!glyphName.equals(name)) continue;
            return code;
        }
        return -1;
    }

    private static void updateMatrix(MessageDigest digest, Matrix matrix) {
        if (matrix == null) {
            Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)-1);
            return;
        }
        float[][] values = matrix.getValues();
        Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)values.length);
        for (float[] row : values) {
            if (row == null) {
                Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)-1);
                continue;
            }
            Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)row.length);
            for (float value : row) {
                Type3FontSignatureCalculator.updateFloat((MessageDigest)digest, (float)value);
            }
        }
    }

    private static void updateRectangle(MessageDigest digest, PDRectangle rectangle) {
        if (rectangle == null) {
            Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)-1);
            return;
        }
        Type3FontSignatureCalculator.updateFloat((MessageDigest)digest, (float)rectangle.getLowerLeftX());
        Type3FontSignatureCalculator.updateFloat((MessageDigest)digest, (float)rectangle.getLowerLeftY());
        Type3FontSignatureCalculator.updateFloat((MessageDigest)digest, (float)rectangle.getUpperRightX());
        Type3FontSignatureCalculator.updateFloat((MessageDigest)digest, (float)rectangle.getUpperRightY());
    }

    private static void updateRectangle(MessageDigest digest, COSArray array) {
        if (array == null) {
            Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)-1);
            return;
        }
        Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)array.size());
        for (int i = 0; i < array.size(); ++i) {
            COSBase value = array.getObject(i);
            if (value instanceof COSNumber) {
                COSNumber number = (COSNumber)value;
                Type3FontSignatureCalculator.updateFloat((MessageDigest)digest, (float)number.floatValue());
                continue;
            }
            Type3FontSignatureCalculator.updateFloat((MessageDigest)digest, (float)0.0f);
        }
    }

    private static void updateString(MessageDigest digest, String value) {
        if (value == null) {
            Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)-1);
            return;
        }
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        Type3FontSignatureCalculator.updateInt((MessageDigest)digest, (int)bytes.length);
        digest.update(bytes);
    }

    private static void updateInt(MessageDigest digest, int value) {
        digest.update(ByteBuffer.allocate(4).putInt(value).array());
    }

    private static void updateFloat(MessageDigest digest, float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            value = 0.0f;
        }
        digest.update(ByteBuffer.allocate(4).putFloat(value).array());
    }

    private static MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Missing SHA-256 MessageDigest", ex);
        }
    }

    private static String toHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte value : bytes) {
            builder.append(String.format(Locale.ROOT, "%02x", Byte.toUnsignedInt(value)));
        }
        return builder.toString();
    }
}

