/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.PdfJsonConversionProgress;
import stirling.software.SPDF.model.json.PdfJsonAnnotation;
import stirling.software.SPDF.model.json.PdfJsonCosValue;
import stirling.software.SPDF.model.json.PdfJsonDocumentMetadata;
import stirling.software.SPDF.model.json.PdfJsonFont;
import stirling.software.SPDF.model.json.PdfJsonPage;
import stirling.software.SPDF.model.json.PdfJsonPageDimension;
import stirling.software.SPDF.model.json.PdfJsonStream;
import stirling.software.SPDF.model.json.PdfJsonTextElement;
import stirling.software.SPDF.service.pdfjson.PdfJsonImageService;
import stirling.software.SPDF.service.pdfjson.PdfJsonMetadataService;
import stirling.software.SPDF.service.pdfjson.PdfLazyLoadingService;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.service.TaskManager;
import stirling.software.common.util.ExceptionUtils;

@Service
public class PdfLazyLoadingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfLazyLoadingService.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final ObjectMapper objectMapper;
    private final TaskManager taskManager;
    private final PdfJsonMetadataService metadataService;
    private final PdfJsonImageService imageService;
    private final Map<String, CachedPdfDocument> documentCache = new ConcurrentHashMap();

    public byte[] extractDocumentMetadata(MultipartFile file, String jobId, Map<String, PdfJsonFont> fonts, Map<Integer, Map<PDFont, String>> pageFontResources) throws IOException {
        if (file == null) {
            throw ExceptionUtils.createNullArgumentException((String)"fileInput");
        }
        Consumer<PdfJsonConversionProgress> progress = jobId != null ? p -> {
            log.info("Progress: [{}%] {} - {}{}", new Object[]{p.getPercent(), p.getStage(), p.getMessage(), p.getCurrent() != null && p.getTotal() != null ? String.format(" (%d/%d)", p.getCurrent(), p.getTotal()) : ""});
            this.reportProgressToTaskManager(jobId, p);
        } : p -> {};
        byte[] pdfBytes = file.getBytes();
        try (PDDocument document = this.pdfDocumentFactory.load(pdfBytes, true);){
            int totalPages = document.getNumberOfPages();
            progress.accept(PdfJsonConversionProgress.of((int)90, (String)"metadata", (String)"Extracting metadata"));
            PdfJsonDocumentMetadata docMetadata = new PdfJsonDocumentMetadata();
            docMetadata.setMetadata(this.metadataService.extractMetadata(document));
            docMetadata.setXmpMetadata(this.metadataService.extractXmpMetadata(document));
            docMetadata.setLazyImages(Boolean.TRUE);
            ArrayList<PdfJsonFont> serializedFonts = new ArrayList<PdfJsonFont>(fonts.values());
            serializedFonts.sort(Comparator.comparing(PdfJsonFont::getUid, Comparator.nullsLast(Comparator.naturalOrder())));
            docMetadata.setFonts(serializedFonts);
            ArrayList<PdfJsonPageDimension> pageDimensions = new ArrayList<PdfJsonPageDimension>();
            int pageIndex = 0;
            for (PDPage page : document.getPages()) {
                PdfJsonPageDimension dim = new PdfJsonPageDimension();
                dim.setPageNumber(Integer.valueOf(pageIndex + 1));
                PDRectangle mediaBox = page.getMediaBox();
                dim.setWidth(Float.valueOf(mediaBox.getWidth()));
                dim.setHeight(Float.valueOf(mediaBox.getHeight()));
                dim.setRotation(Integer.valueOf(page.getRotation()));
                pageDimensions.add(dim);
                ++pageIndex;
            }
            docMetadata.setPageDimensions(pageDimensions);
            if (jobId != null) {
                CachedPdfDocument cached = new CachedPdfDocument(pdfBytes, docMetadata);
                this.documentCache.put(jobId, cached);
                log.info("Cached PDF bytes ({} bytes) for lazy loading, jobId: {}", (Object)pdfBytes.length, (Object)jobId);
                this.scheduleDocumentCleanup(jobId);
            }
            progress.accept(PdfJsonConversionProgress.of((int)100, (String)"complete", (String)"Metadata extraction complete"));
            Object object = this.objectMapper.writeValueAsBytes((Object)docMetadata);
            return object;
        }
    }

    public byte[] extractSinglePage(String jobId, int pageNumber, Function<COSBase, PdfJsonCosValue> serializeCosValue, Function<PDPage, List<PdfJsonStream>> extractContentStreams, Function<COSBase, COSBase> filterImageXObjectsFromResources, BiFunction<PDDocument, Integer, List<PdfJsonTextElement>> extractText, BiFunction<PDDocument, Integer, List<PdfJsonAnnotation>> extractAnnotations) throws IOException {
        CachedPdfDocument cached = (CachedPdfDocument)this.documentCache.get(jobId);
        if (cached == null) {
            throw new IllegalArgumentException("No cached document found for jobId: " + jobId);
        }
        int pageIndex = pageNumber - 1;
        int totalPages = cached.getMetadata().getPageDimensions().size();
        if (pageIndex < 0 || pageIndex >= totalPages) {
            throw new IllegalArgumentException("Page number " + pageNumber + " out of range (1-" + totalPages + ")");
        }
        log.debug("Loading PDF from bytes to extract page {} (jobId: {})", (Object)pageNumber, (Object)jobId);
        try (PDDocument document = this.pdfDocumentFactory.load(cached.getPdfBytes(), true);){
            PDPage page = document.getPage(pageIndex);
            PdfJsonPage pageModel = new PdfJsonPage();
            pageModel.setPageNumber(Integer.valueOf(pageNumber));
            PDRectangle mediaBox = page.getMediaBox();
            pageModel.setWidth(Float.valueOf(mediaBox.getWidth()));
            pageModel.setHeight(Float.valueOf(mediaBox.getHeight()));
            pageModel.setRotation(Integer.valueOf(page.getRotation()));
            pageModel.setTextElements(extractText.apply(document, pageNumber));
            pageModel.setAnnotations(extractAnnotations.apply(document, pageNumber));
            List images = this.imageService.extractImagesForPage(document, page, pageNumber);
            pageModel.setImageElements(images);
            COSBase resourcesBase = page.getCOSObject().getDictionaryObject(COSName.RESOURCES);
            COSBase filteredResources = filterImageXObjectsFromResources.apply(resourcesBase);
            pageModel.setResources(serializeCosValue.apply(filteredResources));
            pageModel.setContentStreams(extractContentStreams.apply(page));
            log.debug("Extracted page {} (text: {}, images: {}, annotations: {}) for jobId: {}", new Object[]{pageNumber, pageModel.getTextElements().size(), images.size(), pageModel.getAnnotations().size(), jobId});
            byte[] byArray = this.objectMapper.writeValueAsBytes((Object)pageModel);
            return byArray;
        }
    }

    public void clearCachedDocument(String jobId) {
        CachedPdfDocument cached = (CachedPdfDocument)this.documentCache.remove(jobId);
        if (cached != null) {
            log.info("Removed cached PDF bytes ({} bytes) for jobId: {}", (Object)cached.getPdfBytes().length, (Object)jobId);
        }
    }

    private void scheduleDocumentCleanup(String jobId) {
        new Thread(() -> {
            try {
                Thread.sleep(TimeUnit.MINUTES.toMillis(30L));
                this.clearCachedDocument(jobId);
                log.info("Auto-cleaned cached document for jobId: {}", (Object)jobId);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    private void reportProgressToTaskManager(String jobId, PdfJsonConversionProgress progress) {
        try {
            log.info("Reporting progress for job {}: {}% - {}", new Object[]{jobId, progress.getPercent(), progress.getStage()});
            String note = progress.getCurrent() != null && progress.getTotal() != null ? String.format("[%d%%] %s: %s (%d/%d)", progress.getPercent(), progress.getStage(), progress.getMessage(), progress.getCurrent(), progress.getTotal()) : String.format("[%d%%] %s: %s", progress.getPercent(), progress.getStage(), progress.getMessage());
            boolean added = this.taskManager.addNote(jobId, note);
            if (!added) {
                log.warn("Failed to add note - job {} not found in TaskManager", (Object)jobId);
            } else {
                log.info("Successfully added progress note for job {}: {}", (Object)jobId, (Object)note);
            }
        }
        catch (Exception e) {
            log.error("Exception reporting progress for job {}: {}", new Object[]{jobId, e.getMessage(), e});
        }
    }

    @Generated
    public PdfLazyLoadingService(CustomPDFDocumentFactory pdfDocumentFactory, ObjectMapper objectMapper, TaskManager taskManager, PdfJsonMetadataService metadataService, PdfJsonImageService imageService) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.objectMapper = objectMapper;
        this.taskManager = taskManager;
        this.metadataService = metadataService;
        this.imageService = imageService;
    }
}

