/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import stirling.software.SPDF.model.api.PdfJsonConversionProgress;
import stirling.software.SPDF.model.json.PdfJsonImageElement;
import stirling.software.SPDF.service.pdfjson.PdfJsonImageService;

@Service
public class PdfJsonImageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfJsonImageService.class);

    public Map<Integer, List<PdfJsonImageElement>> collectImages(PDDocument document, int totalPages, Consumer<PdfJsonConversionProgress> progress) throws IOException {
        LinkedHashMap<Integer, List<PdfJsonImageElement>> imagesByPage = new LinkedHashMap<Integer, List<PdfJsonImageElement>>();
        IdentityHashMap imageCache = new IdentityHashMap();
        int pageNumber = 1;
        for (PDPage page : document.getPages()) {
            ImageCollectingEngine engine = new ImageCollectingEngine(this, page, pageNumber, imagesByPage, imageCache);
            engine.processPage(page);
            int imageProgress = 70 + (int)((double)pageNumber / (double)totalPages * 10.0);
            progress.accept(PdfJsonConversionProgress.of((int)imageProgress, (String)"images", (String)"Extracting images", (int)pageNumber, (int)totalPages));
            ++pageNumber;
        }
        return imagesByPage;
    }

    public List<PdfJsonImageElement> extractImagesForPage(PDDocument document, PDPage page, int pageNumber) throws IOException {
        LinkedHashMap imagesByPage = new LinkedHashMap();
        ImageCollectingEngine engine = new ImageCollectingEngine(this, page, pageNumber, imagesByPage, new IdentityHashMap());
        engine.processPage(page);
        return imagesByPage.getOrDefault(pageNumber, new ArrayList());
    }

    public void drawImageElement(PDPageContentStream contentStream, PDDocument document, PdfJsonImageElement element, Map<String, PDImageXObject> cache) throws IOException {
        List transform;
        if (element == null || element.getImageData() == null || element.getImageData().isBlank()) {
            return;
        }
        String cacheKey = element.getId() != null && !element.getId().isBlank() ? element.getId() : Integer.toHexString(System.identityHashCode(element));
        PDImageXObject image = cache.get(cacheKey);
        if (image == null) {
            image = this.createImageXObject(document, element);
            if (image == null) {
                return;
            }
            cache.put(cacheKey, image);
        }
        if ((transform = element.getTransform()) != null && transform.size() == 6) {
            Matrix matrix = new Matrix(this.safeFloat((Float)transform.get(0), 1.0f), this.safeFloat((Float)transform.get(1), 0.0f), this.safeFloat((Float)transform.get(2), 0.0f), this.safeFloat((Float)transform.get(3), 1.0f), this.safeFloat((Float)transform.get(4), 0.0f), this.safeFloat((Float)transform.get(5), 0.0f));
            contentStream.drawImage(image, matrix);
            return;
        }
        float width = this.safeFloat(element.getWidth(), this.fallbackWidth(element));
        float height = this.safeFloat(element.getHeight(), this.fallbackHeight(element));
        if (width <= 0.0f) {
            width = Math.max(1.0f, this.fallbackWidth(element));
        }
        if (height <= 0.0f) {
            height = Math.max(1.0f, this.fallbackHeight(element));
        }
        float left = this.resolveLeft(element, width);
        float bottom = this.resolveBottom(element, height);
        contentStream.drawImage(image, left, bottom, width, height);
    }

    public PDImageXObject createImageXObject(PDDocument document, PdfJsonImageElement element) throws IOException {
        byte[] data;
        try {
            data = Base64.getDecoder().decode(element.getImageData());
        }
        catch (IllegalArgumentException ex) {
            log.debug("Failed to decode image element: {}", (Object)ex.getMessage());
            return null;
        }
        String name = element.getId() != null ? element.getId() : UUID.randomUUID().toString();
        return PDImageXObject.createFromByteArray((PDDocument)document, (byte[])data, (String)name);
    }

    private EncodedImage encodeImage(PDImage image) {
        try {
            ByteArrayOutputStream baos;
            boolean written;
            BufferedImage bufferedImage = image.getImage();
            if (bufferedImage == null) {
                return null;
            }
            String format = this.resolveImageFormat(image);
            if (format == null || format.isBlank()) {
                format = "png";
            }
            if (!(written = ImageIO.write((RenderedImage)bufferedImage, format, baos = new ByteArrayOutputStream()))) {
                if (!"png".equalsIgnoreCase(format)) {
                    baos.reset();
                    if (!ImageIO.write((RenderedImage)bufferedImage, "png", baos)) {
                        return null;
                    }
                    format = "png";
                } else {
                    return null;
                }
            }
            return new EncodedImage(Base64.getEncoder().encodeToString(baos.toByteArray()), format);
        }
        catch (IOException ex) {
            log.debug("Failed to encode image: {}", (Object)ex.getMessage());
            return null;
        }
    }

    private String resolveImageFormat(PDImage image) {
        PDImageXObject xObject;
        String suffix;
        if (image instanceof PDImageXObject && (suffix = (xObject = (PDImageXObject)image).getSuffix()) != null && !suffix.isBlank()) {
            return suffix.toLowerCase(Locale.ROOT);
        }
        return "png";
    }

    private float fallbackWidth(PdfJsonImageElement element) {
        if (element.getRight() != null && element.getLeft() != null) {
            return Math.max(0.0f, element.getRight().floatValue() - element.getLeft().floatValue());
        }
        if (element.getNativeWidth() != null) {
            return element.getNativeWidth().intValue();
        }
        return 1.0f;
    }

    private float fallbackHeight(PdfJsonImageElement element) {
        if (element.getTop() != null && element.getBottom() != null) {
            return Math.max(0.0f, element.getTop().floatValue() - element.getBottom().floatValue());
        }
        if (element.getNativeHeight() != null) {
            return element.getNativeHeight().intValue();
        }
        return 1.0f;
    }

    private float resolveLeft(PdfJsonImageElement element, float width) {
        if (element.getLeft() != null) {
            return element.getLeft().floatValue();
        }
        if (element.getX() != null) {
            return element.getX().floatValue();
        }
        if (element.getRight() != null) {
            return element.getRight().floatValue() - width;
        }
        return 0.0f;
    }

    private float resolveBottom(PdfJsonImageElement element, float height) {
        if (element.getBottom() != null) {
            return element.getBottom().floatValue();
        }
        if (element.getY() != null) {
            return element.getY().floatValue();
        }
        if (element.getTop() != null) {
            return element.getTop().floatValue() - height;
        }
        return 0.0f;
    }

    private List<Float> toMatrixValues(Matrix matrix) {
        ArrayList<Float> values = new ArrayList<Float>(6);
        values.add(Float.valueOf(matrix.getValue(0, 0)));
        values.add(Float.valueOf(matrix.getValue(0, 1)));
        values.add(Float.valueOf(matrix.getValue(1, 0)));
        values.add(Float.valueOf(matrix.getValue(1, 1)));
        values.add(Float.valueOf(matrix.getValue(2, 0)));
        values.add(Float.valueOf(matrix.getValue(2, 1)));
        return values;
    }

    private float safeFloat(Float value, float defaultValue) {
        if (value == null || Float.isNaN(value.floatValue()) || Float.isInfinite(value.floatValue())) {
            return defaultValue;
        }
        return value.floatValue();
    }
}

