/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.pdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stirling.software.SPDF.model.PDFText;
import stirling.software.common.util.RegexPatternUtils;

public class TextFinder
extends PDFTextStripper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextFinder.class);
    private final String searchTerm;
    private final boolean useRegex;
    private final boolean wholeWordSearch;
    private final List<PDFText> foundTexts = new ArrayList();
    private final List<TextPosition> pageTextPositions = new ArrayList();
    private final StringBuilder pageTextBuilder = new StringBuilder();

    public TextFinder(String searchTerm, boolean useRegex, boolean wholeWordSearch) throws IOException {
        this.searchTerm = searchTerm;
        this.useRegex = useRegex;
        this.wholeWordSearch = wholeWordSearch;
        this.setWordSeparator(" ");
    }

    protected void startPage(PDPage page) throws IOException {
        super.startPage(page);
        this.pageTextPositions.clear();
        this.pageTextBuilder.setLength(0);
    }

    protected void writeString(String text, List<TextPosition> textPositions) {
        this.pageTextBuilder.append(text);
        this.pageTextPositions.addAll(textPositions);
    }

    protected void writeWordSeparator() {
        this.pageTextBuilder.append(this.getWordSeparator());
        this.pageTextPositions.add(null);
    }

    protected void writeLineSeparator() {
        this.pageTextBuilder.append(this.getLineSeparator());
        this.pageTextPositions.add(null);
    }

    protected void endPage(PDPage page) throws IOException {
        Object regex;
        String text = this.pageTextBuilder.toString();
        if (text.isEmpty() || this.searchTerm == null || this.searchTerm.isEmpty()) {
            super.endPage(page);
            return;
        }
        String processedSearchTerm = this.searchTerm.trim();
        if (processedSearchTerm.isEmpty()) {
            super.endPage(page);
            return;
        }
        Object object = regex = this.useRegex ? processedSearchTerm : "\\Q" + processedSearchTerm + "\\E";
        if (this.wholeWordSearch) {
            regex = processedSearchTerm.length() == 1 && Character.isDigit(processedSearchTerm.charAt(0)) ? "(?<![\\w])(?<!\\d[\\.,])" + (String)regex + "(?![\\w])(?![\\.,]\\d)" : (processedSearchTerm.length() == 1 ? "(?<![\\w])" + (String)regex + "(?![\\w])" : "\\b" + (String)regex + "\\b");
        }
        Pattern pattern = RegexPatternUtils.getInstance().createSearchPattern((String)regex, true);
        Matcher matcher = pattern.matcher(text);
        log.debug("Searching for '{}' in page {} with regex '{}' (wholeWord: {}, useRegex: {})", new Object[]{processedSearchTerm, this.getCurrentPageNo(), regex, this.wholeWordSearch, this.useRegex});
        int matchCount = 0;
        while (matcher.find()) {
            TextPosition pos;
            int i;
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            log.debug("Found match #{} at positions {}-{}: '{}'", new Object[]{++matchCount, matchStart, matchEnd, matcher.group()});
            float minX = Float.MAX_VALUE;
            float minY = Float.MAX_VALUE;
            float maxX = Float.MIN_VALUE;
            float maxY = Float.MIN_VALUE;
            boolean foundPosition = false;
            for (i = matchStart; i < matchEnd; ++i) {
                if (i >= this.pageTextPositions.size()) {
                    log.debug("Position index {} exceeds available positions ({})", (Object)i, (Object)this.pageTextPositions.size());
                    continue;
                }
                pos = (TextPosition)this.pageTextPositions.get(i);
                if (pos == null) continue;
                foundPosition = true;
                minX = Math.min(minX, pos.getX());
                maxX = Math.max(maxX, pos.getX() + pos.getWidth());
                minY = Math.min(minY, pos.getY() - pos.getHeight());
                maxY = Math.max(maxY, pos.getY());
            }
            if (!foundPosition && matchStart < this.pageTextPositions.size()) {
                log.debug("Attempting to find nearby positions for match at {}-{}", (Object)matchStart, (Object)matchEnd);
                for (i = Math.max(0, matchStart - 5); i < Math.min(this.pageTextPositions.size(), matchEnd + 5); ++i) {
                    pos = (TextPosition)this.pageTextPositions.get(i);
                    if (pos == null) continue;
                    foundPosition = true;
                    minX = Math.min(minX, pos.getX());
                    maxX = Math.max(maxX, pos.getX() + pos.getWidth());
                    minY = Math.min(minY, pos.getY() - pos.getHeight());
                    maxY = Math.max(maxY, pos.getY());
                    break;
                }
            }
            if (foundPosition) {
                this.foundTexts.add(new PDFText(this.getCurrentPageNo() - 1, minX, minY, maxX, maxY, matcher.group()));
                log.debug("Added PDFText for match: page={}, bounds=({},{},{},{}), text='{}'", new Object[]{this.getCurrentPageNo() - 1, Float.valueOf(minX), Float.valueOf(minY), Float.valueOf(maxX), Float.valueOf(maxY), matcher.group()});
                continue;
            }
            log.warn("Found text match '{}' but no valid position data at {}-{}", new Object[]{matcher.group(), matchStart, matchEnd});
        }
        log.debug("Page {} search complete: found {} matches for '{}'", new Object[]{this.getCurrentPageNo(), matchCount, processedSearchTerm});
        super.endPage(page);
    }

    public String getDebugInfo() {
        StringBuilder debug = new StringBuilder();
        debug.append("Extracted text length: ").append(this.pageTextBuilder.length()).append("\n");
        debug.append("Position count: ").append(this.pageTextPositions.size()).append("\n");
        debug.append("Text content: '").append(this.pageTextBuilder.toString().replace("\n", "\\n").replace("\r", "\\r")).append("'\n");
        String text = this.pageTextBuilder.toString();
        for (int i = 0; i < Math.min(text.length(), 50); ++i) {
            char c = text.charAt(i);
            TextPosition pos = i < this.pageTextPositions.size() ? (TextPosition)this.pageTextPositions.get(i) : null;
            debug.append(String.format("  [%d] '%c' (0x%02X) -> %s\n", i, Character.valueOf(c), (int)c, pos != null ? String.format("(%.1f,%.1f)", Float.valueOf(pos.getX()), Float.valueOf(pos.getY())) : "null"));
        }
        return debug.toString();
    }

    @Generated
    public List<PDFText> getFoundTexts() {
        return this.foundTexts;
    }
}

