/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api.misc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import stirling.software.common.model.api.PDFFile;

public class OptimizePdfRequest
extends PDFFile {
    @Schema(description="The level of optimization to apply to the PDF file. Higher values indicate greater compression but may reduce quality.", type="integer", requiredMode=Schema.RequiredMode.REQUIRED, allowableValues={"1", "2", "3", "4", "5", "6", "7", "8", "9"})
    private Integer optimizeLevel = 5;
    @Schema(description="The expected output size, e.g. '100MB', '25KB', etc.", defaultValue="25KB", requiredMode=Schema.RequiredMode.REQUIRED)
    private String expectedOutputSize;
    @Schema(description="Whether to linearize the PDF for faster web viewing. Default is false.", requiredMode=Schema.RequiredMode.REQUIRED, defaultValue="false")
    private Boolean linearize = false;
    @Schema(description="Whether to normalize the PDF content for better compatibility. Default is false.", requiredMode=Schema.RequiredMode.REQUIRED, defaultValue="false")
    private Boolean normalize = false;
    @Schema(description="Whether to convert the PDF to grayscale. Default is false.", requiredMode=Schema.RequiredMode.REQUIRED, defaultValue="false")
    private Boolean grayscale = false;

    @Generated
    public OptimizePdfRequest() {
    }

    @Generated
    public Integer getOptimizeLevel() {
        return this.optimizeLevel;
    }

    @Generated
    public String getExpectedOutputSize() {
        return this.expectedOutputSize;
    }

    @Generated
    public Boolean getLinearize() {
        return this.linearize;
    }

    @Generated
    public Boolean getNormalize() {
        return this.normalize;
    }

    @Generated
    public Boolean getGrayscale() {
        return this.grayscale;
    }

    @Generated
    public void setOptimizeLevel(Integer optimizeLevel) {
        this.optimizeLevel = optimizeLevel;
    }

    @Generated
    public void setExpectedOutputSize(String expectedOutputSize) {
        this.expectedOutputSize = expectedOutputSize;
    }

    @Generated
    public void setLinearize(Boolean linearize) {
        this.linearize = linearize;
    }

    @Generated
    public void setNormalize(Boolean normalize) {
        this.normalize = normalize;
    }

    @Generated
    public void setGrayscale(Boolean grayscale) {
        this.grayscale = grayscale;
    }

    @Generated
    public String toString() {
        return "OptimizePdfRequest(optimizeLevel=" + this.getOptimizeLevel() + ", expectedOutputSize=" + this.getExpectedOutputSize() + ", linearize=" + this.getLinearize() + ", normalize=" + this.getNormalize() + ", grayscale=" + this.getGrayscale() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizePdfRequest)) {
            return false;
        }
        OptimizePdfRequest other = (OptimizePdfRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$optimizeLevel = this.getOptimizeLevel();
        Integer other$optimizeLevel = other.getOptimizeLevel();
        if (this$optimizeLevel == null ? other$optimizeLevel != null : !((Object)this$optimizeLevel).equals(other$optimizeLevel)) {
            return false;
        }
        Boolean this$linearize = this.getLinearize();
        Boolean other$linearize = other.getLinearize();
        if (this$linearize == null ? other$linearize != null : !((Object)this$linearize).equals(other$linearize)) {
            return false;
        }
        Boolean this$normalize = this.getNormalize();
        Boolean other$normalize = other.getNormalize();
        if (this$normalize == null ? other$normalize != null : !((Object)this$normalize).equals(other$normalize)) {
            return false;
        }
        Boolean this$grayscale = this.getGrayscale();
        Boolean other$grayscale = other.getGrayscale();
        if (this$grayscale == null ? other$grayscale != null : !((Object)this$grayscale).equals(other$grayscale)) {
            return false;
        }
        String this$expectedOutputSize = this.getExpectedOutputSize();
        String other$expectedOutputSize = other.getExpectedOutputSize();
        return !(this$expectedOutputSize == null ? other$expectedOutputSize != null : !this$expectedOutputSize.equals(other$expectedOutputSize));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OptimizePdfRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $optimizeLevel = this.getOptimizeLevel();
        result = result * 59 + ($optimizeLevel == null ? 43 : ((Object)$optimizeLevel).hashCode());
        Boolean $linearize = this.getLinearize();
        result = result * 59 + ($linearize == null ? 43 : ((Object)$linearize).hashCode());
        Boolean $normalize = this.getNormalize();
        result = result * 59 + ($normalize == null ? 43 : ((Object)$normalize).hashCode());
        Boolean $grayscale = this.getGrayscale();
        result = result * 59 + ($grayscale == null ? 43 : ((Object)$grayscale).hashCode());
        String $expectedOutputSize = this.getExpectedOutputSize();
        result = result * 59 + ($expectedOutputSize == null ? 43 : $expectedOutputSize.hashCode());
        return result;
    }
}

