/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDJavascriptNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;
import org.apache.xmpbox.xml.XmpSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.JsonDataResponse;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.SecurityApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@SecurityApi
public class GetInfoOnPDF {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetInfoOnPDF.class);
    static ObjectMapper objectMapper = new ObjectMapper();
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    private static void addOutlinesToArray(PDOutlineItem outline, ArrayNode arrayNode) {
        if (outline == null) {
            return;
        }
        ObjectNode outlineNode = objectMapper.createObjectNode();
        outlineNode.put("Title", outline.getTitle());
        arrayNode.add((JsonNode)outlineNode);
        for (PDOutlineItem child = outline.getFirstChild(); child != null; child = child.getNextSibling()) {
            GetInfoOnPDF.addOutlinesToArray((PDOutlineItem)child, (ArrayNode)arrayNode);
        }
    }

    public static boolean checkForStandard(PDDocument document, String standardKeyword) {
        if ("PDF/A".equalsIgnoreCase(standardKeyword)) {
            return GetInfoOnPDF.getPdfAConformanceLevel((PDDocument)document) != null;
        }
        return GetInfoOnPDF.checkStandardInMetadata((PDDocument)document, (String)standardKeyword);
    }

    public static String getPdfAConformanceLevel(PDDocument document) {
        if (document == null || document.isEncrypted()) {
            return null;
        }
        return GetInfoOnPDF.getPdfAVersionFromMetadata((PDDocument)document);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPdfAVersionFromMetadata(PDDocument document) {
        try {
            PDMetadata pdMetadata = document.getDocumentCatalog().getMetadata();
            if (pdMetadata == null) return null;
            try (COSInputStream metaStream = pdMetadata.createInputStream();){
                DomXmpParser domXmpParser = new DomXmpParser();
                XMPMetadata xmpMeta = domXmpParser.parse((InputStream)metaStream);
                PDFAIdentificationSchema pdfId = xmpMeta.getPDFAIdentificationSchema();
                if (pdfId != null) {
                    Integer part = pdfId.getPart();
                    String conformance = pdfId.getConformance();
                    if (part == null) return null;
                    if (conformance == null) return null;
                    String string = part + conformance.toUpperCase(Locale.ROOT);
                    return string;
                }
                try (COSInputStream rawStream = pdMetadata.createInputStream();){
                    byte[] metadataBytes = rawStream.readAllBytes();
                    String rawMetadata = new String(metadataBytes, StandardCharsets.UTF_8);
                    String extracted = GetInfoOnPDF.extractPdfAVersionFromRawXml((String)rawMetadata);
                    if (extracted == null) return null;
                    String string = extracted;
                    return string;
                }
            }
            catch (XmpParsingException e) {
                log.debug("XMP parsing failed, trying raw metadata search: {}", (Object)e.getMessage());
                try (COSInputStream metaStream2 = pdMetadata.createInputStream();){
                    byte[] metadataBytes = metaStream2.readAllBytes();
                    String rawMetadata = new String(metadataBytes, StandardCharsets.UTF_8);
                    String extracted = GetInfoOnPDF.extractPdfAVersionFromRawXml((String)rawMetadata);
                    if (extracted == null) return null;
                    String string = extracted;
                    return string;
                }
            }
        }
        catch (Exception e) {
            log.debug("Error reading PDF/A metadata: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static String extractPdfAVersionFromRawXml(String rawXml) {
        if (rawXml == null || rawXml.isEmpty()) {
            return null;
        }
        try {
            Pattern partPattern = RegexPatternUtils.getInstance().getPdfAidPartPattern();
            Pattern confPattern = RegexPatternUtils.getInstance().getPdfAidConformancePattern();
            Matcher partMatcher = partPattern.matcher(rawXml);
            Matcher confMatcher = confPattern.matcher(rawXml);
            if (partMatcher.find() && confMatcher.find()) {
                String part = partMatcher.group(1);
                String conformance = confMatcher.group(1).toUpperCase(Locale.ROOT);
                return part + conformance;
            }
        }
        catch (Exception e) {
            log.debug("Error parsing raw XMP for PDF/A version: {}", (Object)e.getMessage());
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static boolean validatePdfAWithPreflight(PDDocument document, String version) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkStandardInMetadata(PDDocument document, String standardKeyword) {
        try {
            block17: {
                boolean bl;
                PDMetadata pdMetadata = document.getDocumentCatalog().getMetadata();
                if (pdMetadata == null) return false;
                try (COSInputStream metaStream = pdMetadata.createInputStream();){
                    byte[] metadataBytes = metaStream.readAllBytes();
                    String rawMetadata = new String(metadataBytes, StandardCharsets.UTF_8);
                    if (rawMetadata.contains(standardKeyword)) {
                        boolean bl2 = true;
                        return bl2;
                    }
                }
                metaStream = pdMetadata.createInputStream();
                try {
                    DomXmpParser domXmpParser = new DomXmpParser();
                    XMPMetadata xmpMeta = domXmpParser.parse((InputStream)metaStream);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    new XmpSerializer().serialize(xmpMeta, (OutputStream)baos, true);
                    String xmpString = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                    if (!xmpString.contains(standardKeyword)) break block17;
                    bl = true;
                    if (metaStream == null) return bl;
                }
                catch (XmpParsingException e) {
                    log.debug("XMP parsing failed for standard check, but raw metadata was already checked: {}", (Object)e.getMessage());
                    return false;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                metaStream.close();
                return bl;
            }
            return false;
        }
        catch (Exception e) {
            ExceptionUtils.logException((String)"PDF standard checking", (Exception)e);
        }
        return false;
    }

    private ObjectNode generatePDFSummaryData(PDDocument document, String pdfaConformanceLevel, Boolean pdfaValidationPassed) {
        ObjectNode summaryData = objectMapper.createObjectNode();
        if (document.isEncrypted()) {
            summaryData.put("encrypted", true);
        }
        AccessPermission ap = document.getCurrentAccessPermission();
        ArrayNode restrictedPermissions = objectMapper.createArrayNode();
        if (!ap.canAssembleDocument()) {
            restrictedPermissions.add("document assembly");
        }
        if (!ap.canExtractContent()) {
            restrictedPermissions.add("content extraction");
        }
        if (!ap.canExtractForAccessibility()) {
            restrictedPermissions.add("accessibility extraction");
        }
        if (!ap.canFillInForm()) {
            restrictedPermissions.add("form filling");
        }
        if (!ap.canModify()) {
            restrictedPermissions.add("modification");
        }
        if (!ap.canModifyAnnotations()) {
            restrictedPermissions.add("annotation modification");
        }
        if (!ap.canPrint()) {
            restrictedPermissions.add("printing");
        }
        if (!restrictedPermissions.isEmpty()) {
            summaryData.set("restrictedPermissions", (JsonNode)restrictedPermissions);
            summaryData.put("restrictedPermissionsCount", restrictedPermissions.size());
        }
        if (pdfaConformanceLevel != null) {
            summaryData.put("standardCompliance", "PDF/A-" + pdfaConformanceLevel);
            summaryData.put("standardPurpose", "long-term archiving");
            if (pdfaValidationPassed != null) {
                summaryData.put("standardValidationPassed", pdfaValidationPassed);
            }
        } else if (GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/X")) {
            summaryData.put("standardCompliance", "PDF/X");
            summaryData.put("standardPurpose", "graphic exchange");
        } else if (GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/UA")) {
            summaryData.put("standardCompliance", "PDF/UA");
            summaryData.put("standardPurpose", "universal accessibility");
        } else if (GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/E")) {
            summaryData.put("standardCompliance", "PDF/E");
            summaryData.put("standardPurpose", "engineering workflows");
        } else if (GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/VT")) {
            summaryData.put("standardCompliance", "PDF/VT");
            summaryData.put("standardPurpose", "variable and transactional printing");
        }
        return summaryData;
    }

    private static void setNodePermissions(PDDocument pdfBoxDoc, ObjectNode permissionsNode) {
        AccessPermission ap = pdfBoxDoc.getCurrentAccessPermission();
        permissionsNode.put("Document Assembly", GetInfoOnPDF.getPermissionState((boolean)ap.canAssembleDocument()));
        permissionsNode.put("Extracting Content", GetInfoOnPDF.getPermissionState((boolean)ap.canExtractContent()));
        permissionsNode.put("Extracting for accessibility", GetInfoOnPDF.getPermissionState((boolean)ap.canExtractForAccessibility()));
        permissionsNode.put("Form Filling", GetInfoOnPDF.getPermissionState((boolean)ap.canFillInForm()));
        permissionsNode.put("Modifying", GetInfoOnPDF.getPermissionState((boolean)ap.canModify()));
        permissionsNode.put("Modifying annotations", GetInfoOnPDF.getPermissionState((boolean)ap.canModifyAnnotations()));
        permissionsNode.put("Printing", GetInfoOnPDF.getPermissionState((boolean)ap.canPrint()));
    }

    private static String getPermissionState(boolean state) {
        return state ? "Allowed" : "Not Allowed";
    }

    public static String getPageOrientation(double width, double height) {
        if (width > height) {
            return "Landscape";
        }
        if (height > width) {
            return "Portrait";
        }
        return "Square";
    }

    public static String getPageSize(float width, float height) {
        HashMap<String, PDRectangle> standardSizes = new HashMap<String, PDRectangle>();
        standardSizes.put("Letter", PDRectangle.LETTER);
        standardSizes.put("LEGAL", PDRectangle.LEGAL);
        standardSizes.put("A0", PDRectangle.A0);
        standardSizes.put("A1", PDRectangle.A1);
        standardSizes.put("A2", PDRectangle.A2);
        standardSizes.put("A3", PDRectangle.A3);
        standardSizes.put("A4", PDRectangle.A4);
        standardSizes.put("A5", PDRectangle.A5);
        standardSizes.put("A6", PDRectangle.A6);
        for (Map.Entry entry : standardSizes.entrySet()) {
            PDRectangle size = (PDRectangle)entry.getValue();
            if (!GetInfoOnPDF.isCloseToSize((float)width, (float)height, (float)size.getWidth(), (float)size.getHeight())) continue;
            return (String)entry.getKey();
        }
        return "Custom";
    }

    private static boolean isCloseToSize(float width, float height, float standardWidth, float standardHeight) {
        float tolerance = 1.0f;
        return Math.abs(width - standardWidth) <= tolerance && Math.abs(height - standardHeight) <= tolerance;
    }

    private static void setDimensionInfo(ObjectNode dimensionInfo, float width, float height) {
        float ppi = 72.0f;
        float widthInInches = width / ppi;
        float heightInInches = height / ppi;
        float widthInCm = widthInInches * 2.54f;
        float heightInCm = heightInInches * 2.54f;
        dimensionInfo.put("Width (px)", String.format("%.2f", Float.valueOf(width)));
        dimensionInfo.put("Height (px)", String.format("%.2f", Float.valueOf(height)));
        dimensionInfo.put("Width (in)", String.format("%.2f", Float.valueOf(widthInInches)));
        dimensionInfo.put("Height (in)", String.format("%.2f", Float.valueOf(heightInInches)));
        dimensionInfo.put("Width (cm)", String.format("%.2f", Float.valueOf(widthInCm)));
        dimensionInfo.put("Height (cm)", String.format("%.2f", Float.valueOf(heightInCm)));
    }

    private static ArrayNode exploreStructureTree(List<Object> nodes) {
        ArrayNode elementsArray = objectMapper.createArrayNode();
        if (nodes != null) {
            for (Object obj : nodes) {
                if (!(obj instanceof PDStructureNode)) continue;
                PDStructureNode node = (PDStructureNode)obj;
                ObjectNode elementNode = objectMapper.createObjectNode();
                if (node instanceof PDStructureElement) {
                    PDStructureElement structureElement = (PDStructureElement)node;
                    elementNode.put("Type", structureElement.getStructureType());
                    elementNode.put("Content", GetInfoOnPDF.getContent((PDStructureElement)structureElement));
                    ArrayNode childElements = GetInfoOnPDF.exploreStructureTree((List)structureElement.getKids());
                    if (!childElements.isEmpty()) {
                        elementNode.set("Children", (JsonNode)childElements);
                    }
                }
                elementsArray.add((JsonNode)elementNode);
            }
        }
        return elementsArray;
    }

    private static String getContent(PDStructureElement structureElement) {
        StringBuilder contentBuilder = new StringBuilder();
        for (Object item : structureElement.getKids()) {
            if (item instanceof COSString) {
                COSString cosString = (COSString)item;
                contentBuilder.append(cosString.getString());
                continue;
            }
            if (!(item instanceof PDStructureElement)) continue;
            PDStructureElement pdstructureelement = (PDStructureElement)item;
            contentBuilder.append(GetInfoOnPDF.getContent((PDStructureElement)pdstructureelement));
        }
        return contentBuilder.toString();
    }

    private static String formatDate(Calendar calendar) {
        if (calendar != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(calendar.toInstant(), ZoneId.systemDefault());
            return zonedDateTime.format(formatter);
        }
        return null;
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/get-info-on-pdf"})
    @JsonDataResponse
    @Operation(summary="Summary here", description="desc. Input:PDF Output:JSON Type:SISO")
    public ResponseEntity<byte[]> getPdfInfo(@ModelAttribute PDFFile request) throws IOException {
        ResponseEntity responseEntity;
        block68: {
            MultipartFile inputFile = request.getFileInput();
            boolean readonly = true;
            String pagePrefix = "Page ";
            int prefixLength = "Page ".length();
            StringBuilder keyBuilder = new StringBuilder(prefixLength + 8);
            keyBuilder.append("Page ");
            PDDocument pdfBoxDoc = this.pdfDocumentFactory.load(inputFile, readonly);
            try {
                PDJavascriptNameTreeNode javascriptDict;
                ObjectNode summaryData;
                ObjectMapper objectMapper = new ObjectMapper();
                ObjectNode jsonOutput = objectMapper.createObjectNode();
                PDDocumentInformation info = pdfBoxDoc.getDocumentInformation();
                ObjectNode metadata = objectMapper.createObjectNode();
                ObjectNode basicInfo = objectMapper.createObjectNode();
                ObjectNode docInfoNode = objectMapper.createObjectNode();
                ObjectNode compliancy = objectMapper.createObjectNode();
                ObjectNode encryption = objectMapper.createObjectNode();
                ObjectNode other = objectMapper.createObjectNode();
                metadata.put("Title", info.getTitle());
                metadata.put("Author", info.getAuthor());
                metadata.put("Subject", info.getSubject());
                metadata.put("Keywords", info.getKeywords());
                metadata.put("Producer", info.getProducer());
                metadata.put("Creator", info.getCreator());
                metadata.put("CreationDate", GetInfoOnPDF.formatDate((Calendar)info.getCreationDate()));
                metadata.put("ModificationDate", GetInfoOnPDF.formatDate((Calendar)info.getModificationDate()));
                jsonOutput.set("Metadata", (JsonNode)metadata);
                long fileSizeInBytes = inputFile.getSize();
                basicInfo.put("FileSizeInBytes", fileSizeInBytes);
                String fullText = new PDFTextStripper().getText(pdfBoxDoc);
                String[] words = RegexPatternUtils.getInstance().getWhitespacePattern().split(fullText);
                int wordCount = words.length;
                int paragraphCount = RegexPatternUtils.getInstance().getMultiFormatNewlinePattern().split(fullText).length;
                basicInfo.put("WordCount", wordCount);
                basicInfo.put("ParagraphCount", paragraphCount);
                int charCount = fullText.length();
                basicInfo.put("CharacterCount", charCount);
                boolean hasCompression = false;
                String compressionType = "None";
                basicInfo.put("Compression", hasCompression);
                if (hasCompression) {
                    basicInfo.put("CompressionType", compressionType);
                }
                String language = pdfBoxDoc.getDocumentCatalog().getLanguage();
                basicInfo.put("Language", language);
                basicInfo.put("Number of pages", pdfBoxDoc.getNumberOfPages());
                PDDocumentCatalog catalog = pdfBoxDoc.getDocumentCatalog();
                String pageMode = catalog.getPageMode().name();
                docInfoNode.put("PDF version", pdfBoxDoc.getVersion());
                docInfoNode.put("Trapped", info.getTrapped());
                docInfoNode.put("Page Mode", GetInfoOnPDF.getPageModeDescription((String)pageMode));
                PDAcroForm acroForm = pdfBoxDoc.getDocumentCatalog().getAcroForm();
                ObjectNode formFieldsNode = objectMapper.createObjectNode();
                if (acroForm != null) {
                    for (PDField field : acroForm.getFieldTree()) {
                        formFieldsNode.put(field.getFullyQualifiedName(), field.getValueAsString());
                    }
                }
                jsonOutput.set("FormFields", (JsonNode)formFieldsNode);
                String pdfaConformanceLevel = GetInfoOnPDF.getPdfAConformanceLevel((PDDocument)pdfBoxDoc);
                Boolean pdfaValidationPassed = null;
                if (pdfaConformanceLevel != null) {
                    pdfaValidationPassed = GetInfoOnPDF.validatePdfAWithPreflight((PDDocument)pdfBoxDoc, (String)pdfaConformanceLevel);
                }
                if ((summaryData = this.generatePDFSummaryData(pdfBoxDoc, pdfaConformanceLevel, pdfaValidationPassed)) != null && !summaryData.isEmpty()) {
                    jsonOutput.set("SummaryData", (JsonNode)summaryData);
                }
                if (catalog.getNames() != null) {
                    Map efMap;
                    PDEmbeddedFilesNameTreeNode efTree = catalog.getNames().getEmbeddedFiles();
                    ArrayNode embeddedFilesArray = objectMapper.createArrayNode();
                    if (efTree != null && (efMap = efTree.getNames()) != null) {
                        for (Map.Entry entry : efMap.entrySet()) {
                            ObjectNode embeddedFileNode = objectMapper.createObjectNode();
                            embeddedFileNode.put("Name", (String)entry.getKey());
                            PDEmbeddedFile pDEmbeddedFile = ((PDComplexFileSpecification)entry.getValue()).getEmbeddedFile();
                            if (pDEmbeddedFile != null) {
                                embeddedFileNode.put("FileSize", pDEmbeddedFile.getLength());
                            }
                            embeddedFilesArray.add((JsonNode)embeddedFileNode);
                        }
                    }
                    other.set("EmbeddedFiles", (JsonNode)embeddedFilesArray);
                }
                ArrayNode attachmentsArray = objectMapper.createArrayNode();
                for (PDPage page : pdfBoxDoc.getPages()) {
                    for (PDAnnotation annotation : page.getAnnotations()) {
                        if (!(annotation instanceof PDAnnotationFileAttachment)) continue;
                        PDAnnotationFileAttachment fileAttachmentAnnotation = (PDAnnotationFileAttachment)annotation;
                        ObjectNode objectNode = objectMapper.createObjectNode();
                        objectNode.put("Name", fileAttachmentAnnotation.getAttachmentName());
                        objectNode.put("Description", fileAttachmentAnnotation.getContents());
                        attachmentsArray.add((JsonNode)objectNode);
                    }
                }
                other.set("Attachments", (JsonNode)attachmentsArray);
                PDDocumentNameDictionary namesDict = catalog.getNames();
                ArrayNode javascriptArray = objectMapper.createArrayNode();
                if (namesDict != null && (javascriptDict = namesDict.getJavaScript()) != null) {
                    try {
                        Map jsEntries = javascriptDict.getNames();
                        for (Map.Entry entry : jsEntries.entrySet()) {
                            String jsCodeStr;
                            ObjectNode jsNode = objectMapper.createObjectNode();
                            jsNode.put("JS Name", (String)entry.getKey());
                            PDActionJavaScript jsAction = (PDActionJavaScript)entry.getValue();
                            if (jsAction != null && (jsCodeStr = jsAction.getAction()) != null) {
                                jsNode.put("JS Script Length", jsCodeStr.length());
                            }
                            javascriptArray.add((JsonNode)jsNode);
                        }
                    }
                    catch (IOException e) {
                        log.error("exception", (Throwable)e);
                    }
                }
                other.set("JavaScript", (JsonNode)javascriptArray);
                PDOptionalContentProperties ocProperties = pdfBoxDoc.getDocumentCatalog().getOCProperties();
                ArrayNode layersArray = objectMapper.createArrayNode();
                if (ocProperties != null) {
                    for (PDOptionalContentGroup pDOptionalContentGroup : ocProperties.getOptionalContentGroups()) {
                        ObjectNode layerNode = objectMapper.createObjectNode();
                        layerNode.put("Name", pDOptionalContentGroup.getName());
                        layersArray.add((JsonNode)layerNode);
                    }
                }
                other.set("Layers", (JsonNode)layersArray);
                PDStructureTreeRoot structureTreeRoot = pdfBoxDoc.getDocumentCatalog().getStructureTreeRoot();
                try {
                    if (structureTreeRoot != null) {
                        ArrayNode arrayNode = GetInfoOnPDF.exploreStructureTree((List)structureTreeRoot.getKids());
                        other.set("StructureTree", (JsonNode)arrayNode);
                    }
                }
                catch (Exception e) {
                    log.error("exception", (Throwable)e);
                }
                boolean isPdfACompliant = pdfaConformanceLevel != null;
                boolean isPdfXCompliant = GetInfoOnPDF.checkForStandard((PDDocument)pdfBoxDoc, (String)"PDF/X");
                boolean isPdfECompliant = GetInfoOnPDF.checkForStandard((PDDocument)pdfBoxDoc, (String)"PDF/E");
                boolean isPdfVTCompliant = GetInfoOnPDF.checkForStandard((PDDocument)pdfBoxDoc, (String)"PDF/VT");
                boolean isPdfUACompliant = GetInfoOnPDF.checkForStandard((PDDocument)pdfBoxDoc, (String)"PDF/UA");
                boolean isPdfBCompliant = GetInfoOnPDF.checkForStandard((PDDocument)pdfBoxDoc, (String)"PDF/B");
                boolean isPdfSECCompliant = GetInfoOnPDF.checkForStandard((PDDocument)pdfBoxDoc, (String)"PDF/SEC");
                compliancy.put("IsPDF/ACompliant", isPdfACompliant);
                if (pdfaConformanceLevel != null) {
                    compliancy.put("PDF/AConformanceLevel", pdfaConformanceLevel);
                    if (pdfaValidationPassed != null) {
                        compliancy.put("IsPDF/AValidated", pdfaValidationPassed);
                    }
                }
                compliancy.put("IsPDF/XCompliant", isPdfXCompliant);
                compliancy.put("IsPDF/ECompliant", isPdfECompliant);
                compliancy.put("IsPDF/VTCompliant", isPdfVTCompliant);
                compliancy.put("IsPDF/UACompliant", isPdfUACompliant);
                compliancy.put("IsPDF/BCompliant", isPdfBCompliant);
                compliancy.put("IsPDF/SECCompliant", isPdfSECCompliant);
                PDDocumentOutline root = pdfBoxDoc.getDocumentCatalog().getDocumentOutline();
                ArrayNode bookmarksArray = objectMapper.createArrayNode();
                if (root != null) {
                    for (PDOutlineItem child : root.children()) {
                        GetInfoOnPDF.addOutlinesToArray((PDOutlineItem)child, (ArrayNode)bookmarksArray);
                    }
                }
                other.set("Bookmarks/Outline/TOC", (JsonNode)bookmarksArray);
                PDMetadata pdMetadata = pdfBoxDoc.getDocumentCatalog().getMetadata();
                String xmpString = null;
                if (pdMetadata != null) {
                    try (COSInputStream is = pdMetadata.createInputStream();){
                        DomXmpParser domXmpParser = new DomXmpParser();
                        XMPMetadata xmpMeta = domXmpParser.parse((InputStream)is);
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        new XmpSerializer().serialize(xmpMeta, (OutputStream)os, true);
                        xmpString = new String(os.toByteArray(), StandardCharsets.UTF_8);
                    }
                    catch (XmpParsingException e) {
                        log.debug("XMP parsing failed, reading raw metadata: {}", (Object)e.getMessage());
                        try (COSInputStream is2 = pdMetadata.createInputStream();){
                            byte[] metadataBytes = is2.readAllBytes();
                            xmpString = new String(metadataBytes, StandardCharsets.UTF_8);
                        }
                    }
                    catch (IOException e) {
                        log.error("exception", (Throwable)e);
                    }
                }
                other.put("XMPMetadata", xmpString);
                if (pdfBoxDoc.isEncrypted()) {
                    encryption.put("IsEncrypted", true);
                    PDEncryption pdfEncryption = pdfBoxDoc.getEncryption();
                    encryption.put("EncryptionAlgorithm", pdfEncryption.getFilter());
                    encryption.put("KeyLength", pdfEncryption.getLength());
                } else {
                    encryption.put("IsEncrypted", false);
                }
                ObjectNode permissionsNode = objectMapper.createObjectNode();
                GetInfoOnPDF.setNodePermissions((PDDocument)pdfBoxDoc, (ObjectNode)permissionsNode);
                ObjectNode pageInfoParent = objectMapper.createObjectNode();
                for (int pageNum = 0; pageNum < pdfBoxDoc.getNumberOfPages(); ++pageNum) {
                    Object name32;
                    ObjectNode pageInfo = objectMapper.createObjectNode();
                    PDPage page = pdfBoxDoc.getPage(pageNum);
                    PDRectangle mediaBox = page.getMediaBox();
                    float width = mediaBox.getWidth();
                    float height = mediaBox.getHeight();
                    ObjectNode sizeInfo = objectMapper.createObjectNode();
                    GetInfoOnPDF.setDimensionInfo((ObjectNode)sizeInfo, (float)width, (float)height);
                    sizeInfo.put("Standard Page", GetInfoOnPDF.getPageSize((float)width, (float)height));
                    pageInfo.set("Size", (JsonNode)sizeInfo);
                    pageInfo.put("Rotation", page.getRotation());
                    pageInfo.put("Page Orientation", GetInfoOnPDF.getPageOrientation((double)width, (double)height));
                    pageInfo.put("MediaBox", mediaBox.toString());
                    PDRectangle cropBox = page.getCropBox();
                    pageInfo.put("CropBox", cropBox == null ? "Undefined" : cropBox.toString());
                    PDRectangle bleedBox = page.getBleedBox();
                    pageInfo.put("BleedBox", bleedBox == null ? "Undefined" : bleedBox.toString());
                    PDRectangle trimBox = page.getTrimBox();
                    pageInfo.put("TrimBox", trimBox == null ? "Undefined" : trimBox.toString());
                    PDRectangle artBox = page.getArtBox();
                    pageInfo.put("ArtBox", artBox == null ? "Undefined" : artBox.toString());
                    PDFTextStripper textStripper = new PDFTextStripper();
                    textStripper.setStartPage(pageNum + 1);
                    textStripper.setEndPage(pageNum + 1);
                    String pageText = textStripper.getText(pdfBoxDoc);
                    pageInfo.put("Text Characters Count", pageText.length());
                    List annotations = page.getAnnotations();
                    int subtypeCount = 0;
                    int contentsCount = 0;
                    for (PDAnnotation annotation : annotations) {
                        if (annotation.getSubtype() != null) {
                            ++subtypeCount;
                        }
                        if (annotation.getContents() == null) continue;
                        ++contentsCount;
                    }
                    ObjectNode annotationsObject = objectMapper.createObjectNode();
                    annotationsObject.put("AnnotationsCount", annotations.size());
                    annotationsObject.put("SubtypeCount", subtypeCount);
                    annotationsObject.put("ContentsCount", contentsCount);
                    pageInfo.set("Annotations", (JsonNode)annotationsObject);
                    ArrayNode imagesArray = objectMapper.createArrayNode();
                    PDResources resources = page.getResources();
                    for (COSName name2 : resources.getXObjectNames()) {
                        PDXObject xObject = resources.getXObject(name2);
                        if (!(xObject instanceof PDImageXObject)) continue;
                        PDImageXObject image = (PDImageXObject)xObject;
                        ObjectNode imageNode = objectMapper.createObjectNode();
                        imageNode.put("Width", image.getWidth());
                        imageNode.put("Height", image.getHeight());
                        if (image.getMetadata() != null && image.getMetadata().getFile() != null && image.getMetadata().getFile().getFile() != null) {
                            imageNode.put("Name", image.getMetadata().getFile().getFile());
                        }
                        if (image.getColorSpace() != null) {
                            imageNode.put("ColorSpace", image.getColorSpace().getName());
                        }
                        imagesArray.add((JsonNode)imageNode);
                    }
                    pageInfo.set("Images", (JsonNode)imagesArray);
                    ArrayNode linksArray = objectMapper.createArrayNode();
                    HashSet<String> uniqueURIs = new HashSet<String>();
                    for (PDAnnotation annotation : annotations) {
                        PDAnnotationLink linkAnnotation;
                        PDAction pDAction;
                        if (!(annotation instanceof PDAnnotationLink) || !((pDAction = (linkAnnotation = (PDAnnotationLink)annotation).getAction()) instanceof PDActionURI)) continue;
                        PDActionURI uriAction = (PDActionURI)pDAction;
                        String uri = uriAction.getURI();
                        uniqueURIs.add(uri);
                    }
                    for (String uri : uniqueURIs) {
                        ObjectNode linkNode = objectMapper.createObjectNode();
                        linkNode.put("URI", uri);
                        linksArray.add((JsonNode)linkNode);
                    }
                    pageInfo.set("Links", (JsonNode)linksArray);
                    ArrayNode fontsArray = objectMapper.createArrayNode();
                    HashMap<String, ObjectNode> uniqueFontsMap = new HashMap<String, ObjectNode>();
                    for (COSName fontName : resources.getFontNames()) {
                        String string;
                        PDFont font = resources.getFont(fontName);
                        ObjectNode fontNode = objectMapper.createObjectNode();
                        fontNode.put("IsEmbedded", font.isEmbedded());
                        fontNode.put("Name", font.getName());
                        fontNode.put("Subtype", font.getType());
                        PDFontDescriptor fontDescriptor = font.getFontDescriptor();
                        if (fontDescriptor != null) {
                            fontNode.put("ItalicAngle", fontDescriptor.getItalicAngle());
                            int n = fontDescriptor.getFlags();
                            fontNode.put("IsItalic", (n & 1) != 0);
                            fontNode.put("IsBold", (n & 0x40) != 0);
                            fontNode.put("IsFixedPitch", (n & 2) != 0);
                            fontNode.put("IsSerif", (n & 4) != 0);
                            fontNode.put("IsSymbolic", (n & 8) != 0);
                            fontNode.put("IsScript", (n & 0x10) != 0);
                            fontNode.put("IsNonsymbolic", (n & 0x20) != 0);
                            fontNode.put("FontFamily", fontDescriptor.getFontFamily());
                            fontNode.put("FontWeight", fontDescriptor.getFontWeight());
                        }
                        if (uniqueFontsMap.containsKey(string = fontNode.toString())) {
                            ObjectNode existingFontNode = (ObjectNode)uniqueFontsMap.get(string);
                            int count = existingFontNode.get("Count").asInt() + 1;
                            existingFontNode.put("Count", count);
                            continue;
                        }
                        fontNode.put("Count", 1);
                        uniqueFontsMap.put(string, fontNode);
                    }
                    for (ObjectNode uniqueFontNode : uniqueFontsMap.values()) {
                        fontsArray.add((JsonNode)uniqueFontNode);
                    }
                    pageInfo.set("Fonts", (JsonNode)fontsArray);
                    ArrayNode colorSpacesArray = objectMapper.createArrayNode();
                    Iterable colorSpaceNames = resources.getColorSpaceNames();
                    for (Object name32 : colorSpaceNames) {
                        PDColorSpace colorSpace = resources.getColorSpace((COSName)name32);
                        if (!(colorSpace instanceof PDICCBased)) continue;
                        PDICCBased pDICCBased = (PDICCBased)colorSpace;
                        PDStream iccData = pDICCBased.getPDStream();
                        byte[] iccBytes = iccData.toByteArray();
                        ObjectNode iccProfileNode = objectMapper.createObjectNode();
                        iccProfileNode.put("ICC Profile Length", iccBytes.length);
                        colorSpacesArray.add((JsonNode)iccProfileNode);
                    }
                    pageInfo.set("Color Spaces & ICC Profiles", (JsonNode)colorSpacesArray);
                    HashMap<String, Integer> xObjectCountMap = new HashMap<String, Integer>();
                    name32 = resources.getXObjectNames().iterator();
                    while (name32.hasNext()) {
                        COSName name4 = (COSName)name32.next();
                        PDXObject pDXObject = resources.getXObject(name4);
                        String xObjectType = pDXObject instanceof PDImageXObject ? "Image" : (pDXObject instanceof PDFormXObject ? "Form" : "Other");
                        xObjectCountMap.put(xObjectType, xObjectCountMap.getOrDefault(xObjectType, 0) + 1);
                    }
                    ObjectNode xObjectCountNode = objectMapper.createObjectNode();
                    for (Map.Entry entry : xObjectCountMap.entrySet()) {
                        xObjectCountNode.put((String)entry.getKey(), (Integer)entry.getValue());
                    }
                    pageInfo.set("XObjectCounts", (JsonNode)xObjectCountNode);
                    ArrayNode multimediaArray = objectMapper.createArrayNode();
                    for (PDAnnotation annotation : annotations) {
                        if (!"RichMedia".equals(annotation.getSubtype())) continue;
                        ObjectNode multimediaNode = objectMapper.createObjectNode();
                        multimediaArray.add((JsonNode)multimediaNode);
                    }
                    pageInfo.set("Multimedia", (JsonNode)multimediaArray);
                    keyBuilder.setLength(prefixLength);
                    keyBuilder.append(pageNum + 1);
                    pageInfoParent.set(keyBuilder.toString(), (JsonNode)pageInfo);
                }
                jsonOutput.set("BasicInfo", (JsonNode)basicInfo);
                jsonOutput.set("DocumentInfo", (JsonNode)docInfoNode);
                jsonOutput.set("Compliancy", (JsonNode)compliancy);
                jsonOutput.set("Encryption", (JsonNode)encryption);
                jsonOutput.set("Permissions", (JsonNode)permissionsNode);
                jsonOutput.set("Other", (JsonNode)other);
                jsonOutput.set("PerPageInfo", (JsonNode)pageInfoParent);
                String jsonString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonOutput);
                responseEntity = WebResponseUtils.bytesToWebResponse((byte[])jsonString.getBytes(StandardCharsets.UTF_8), (String)"response.json", (MediaType)MediaType.APPLICATION_JSON);
                if (pdfBoxDoc == null) break block68;
            }
            catch (Throwable throwable) {
                try {
                    if (pdfBoxDoc != null) {
                        try {
                            pdfBoxDoc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("exception", (Throwable)e);
                    return null;
                }
            }
            pdfBoxDoc.close();
        }
        return responseEntity;
    }

    private static String getPageModeDescription(String pageMode) {
        if (pageMode == null) {
            return "Unknown";
        }
        return RegexPatternUtils.getInstance().getPageModePattern().matcher(pageMode).replaceFirst("");
    }

    @Generated
    public GetInfoOnPDF(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

