/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import io.micrometer.common.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Calendar;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.controller.api.security.CertSignController;
import stirling.software.SPDF.model.api.security.SignPDFWithCertRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.service.ServerCertificateServiceInterface;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/security"})
@Tag(name="Security", description="Security APIs")
public class CertSignController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertSignController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final ServerCertificateServiceInterface serverCertificateService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(MultipartFile.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public CertSignController(CustomPDFDocumentFactory pdfDocumentFactory, @Autowired(required=false) ServerCertificateServiceInterface serverCertificateService) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.serverCertificateService = serverCertificateService;
    }

    private static void sign(CustomPDFDocumentFactory pdfDocumentFactory, MultipartFile input, OutputStream output, CreateSignature instance, Boolean showSignature, Integer pageNumber, String name, String location, String reason, Boolean showLogo) {
        try (PDDocument doc = pdfDocumentFactory.load(input);){
            PDSignature signature = new PDSignature();
            signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
            signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
            signature.setName(name);
            signature.setLocation(location);
            signature.setReason(reason);
            signature.setSignDate(Calendar.getInstance());
            if (Boolean.TRUE.equals(showSignature)) {
                SignatureOptions signatureOptions = new SignatureOptions();
                signatureOptions.setVisualSignature(instance.createVisibleSignature(doc, signature, pageNumber, showLogo));
                signatureOptions.setPage(pageNumber.intValue());
                doc.addSignature(signature, (SignatureInterface)instance, signatureOptions);
            } else {
                doc.addSignature(signature, (SignatureInterface)instance);
            }
            doc.saveIncremental(output);
        }
        catch (Exception e) {
            ExceptionUtils.logException((String)"PDF signing", (Exception)e);
        }
    }

    @AutoJobPostMapping(consumes={"multipart/form-data", "application/x-www-form-urlencoded"}, value={"/cert-sign"})
    @StandardPdfResponse
    @Operation(summary="Sign PDF with a Digital Certificate", description="This endpoint accepts a PDF file, a digital certificate and related information to sign the PDF. It then returns the digitally signed PDF file. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> signPDFWithCert(@ModelAttribute SignPDFWithCertRequest request) throws Exception {
        MultipartFile pdf = request.getFileInput();
        String certType = request.getCertType();
        MultipartFile privateKeyFile = request.getPrivateKeyFile();
        MultipartFile certFile = request.getCertFile();
        MultipartFile p12File = request.getP12File();
        MultipartFile jksfile = request.getJksFile();
        String password = request.getPassword();
        Boolean showSignature = request.getShowSignature();
        String reason = request.getReason();
        String location = request.getLocation();
        String name = request.getName();
        Integer pageNumber = request.getPageNumber() != null ? Integer.valueOf(request.getPageNumber() - 1) : null;
        Boolean showLogo = request.getShowLogo();
        if (StringUtils.isBlank((String)certType)) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.optionsNotSpecified", (String)"{0} options are not specified", (Object[])new Object[]{"certificate type"});
        }
        KeyStore ks = null;
        String keystorePassword = password;
        switch (certType) {
            case "PEM": {
                ks = KeyStore.getInstance("JKS");
                ks.load(null);
                PrivateKey privateKey = this.getPrivateKeyFromPEM(privateKeyFile.getBytes(), password);
                Certificate cert = this.getCertificateFromPEM(certFile.getBytes());
                ks.setKeyEntry("alias", privateKey, password.toCharArray(), new Certificate[]{cert});
                break;
            }
            case "PKCS12": 
            case "PFX": {
                ks = KeyStore.getInstance("PKCS12");
                ks.load(p12File.getInputStream(), password.toCharArray());
                break;
            }
            case "JKS": {
                ks = KeyStore.getInstance("JKS");
                ks.load(jksfile.getInputStream(), password.toCharArray());
                break;
            }
            case "SERVER": {
                if (this.serverCertificateService == null) {
                    throw ExceptionUtils.createIllegalArgumentException((String)"error.serverCertificateNotAvailable", (String)"Server certificate service is not available in this edition", (Object[])new Object[0]);
                }
                if (!this.serverCertificateService.isEnabled()) {
                    throw ExceptionUtils.createIllegalArgumentException((String)"error.serverCertificateDisabled", (String)"Server certificate feature is disabled", (Object[])new Object[0]);
                }
                if (!this.serverCertificateService.hasServerCertificate()) {
                    throw ExceptionUtils.createIllegalArgumentException((String)"error.serverCertificateNotFound", (String)"No server certificate configured", (Object[])new Object[0]);
                }
                ks = this.serverCertificateService.getServerKeyStore();
                keystorePassword = this.serverCertificateService.getServerCertificatePassword();
                break;
            }
            default: {
                throw ExceptionUtils.createIllegalArgumentException((String)"error.invalidArgument", (String)"Invalid argument: {0}", (Object[])new Object[]{"certificate type: " + certType});
            }
        }
        CreateSignature createSignature = new CreateSignature(this, ks, keystorePassword.toCharArray());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CertSignController.sign((CustomPDFDocumentFactory)this.pdfDocumentFactory, (MultipartFile)pdf, (OutputStream)baos, (CreateSignature)createSignature, (Boolean)showSignature, (Integer)pageNumber, (String)name, (String)location, (String)reason, (Boolean)showLogo);
        return WebResponseUtils.bytesToWebResponse((byte[])baos.toByteArray(), (String)GeneralUtils.generateFilename((String)pdf.getOriginalFilename(), (String)"_signed.pdf"));
    }

    private PrivateKey getPrivateKeyFromPEM(byte[] pemBytes, String password) throws IOException, OperatorCreationException, PKCSException {
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(pemBytes)));){
            PrivateKeyInfo pkInfo;
            Object pemObject = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo pkcs8EncryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemObject;
                InputDecryptorProvider decProv = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password.toCharArray());
                pkInfo = pkcs8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(decProv);
            } else if (pemObject instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair pemEncryptedKeyPair = (PEMEncryptedKeyPair)pemObject;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
                pkInfo = pemEncryptedKeyPair.decryptKeyPair(decProv).getPrivateKeyInfo();
            } else {
                pkInfo = ((PEMKeyPair)pemObject).getPrivateKeyInfo();
            }
            PrivateKey privateKey = converter.getPrivateKey(pkInfo);
            return privateKey;
        }
    }

    private Certificate getCertificateFromPEM(byte[] pemBytes) throws IOException, CertificateException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(pemBytes);){
            Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(bis);
            return certificate;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

