/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.misc.AddStampRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class StampController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(MultipartFile.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/add-stamp"})
    @StandardPdfResponse
    @Operation(summary="Add stamp to a PDF file", description="This endpoint adds a stamp to a given PDF file. Users can specify the stamp type (text or image), rotation, opacity, width spacer, and height spacer. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> addStamp(@ModelAttribute AddStampRequest request) throws IOException, Exception {
        MultipartFile pdfFile = request.getFileInput();
        String pdfFileName = pdfFile.getOriginalFilename();
        if (pdfFileName.contains("..") || pdfFileName.startsWith("/")) {
            throw new IllegalArgumentException("Invalid PDF file path");
        }
        String stampType = request.getStampType();
        String stampText = request.getStampText();
        MultipartFile stampImage = request.getStampImage();
        if ("image".equalsIgnoreCase(stampType)) {
            if (stampImage == null) {
                throw new IllegalArgumentException("Stamp image file must be provided when stamp type is 'image'");
            }
            String stampImageName = stampImage.getOriginalFilename();
            if (stampImageName == null || stampImageName.contains("..") || stampImageName.startsWith("/")) {
                throw new IllegalArgumentException("Invalid stamp image file path");
            }
        }
        String alphabet = request.getAlphabet();
        float fontSize = request.getFontSize();
        float rotation = request.getRotation();
        float opacity = request.getOpacity();
        int position = request.getPosition();
        float overrideX = request.getOverrideX();
        float overrideY = request.getOverrideY();
        String customColor = request.getCustomColor();
        float marginFactor = switch (request.getCustomMargin().toLowerCase()) {
            case "small" -> 0.02f;
            case "medium" -> 0.035f;
            case "large" -> 0.05f;
            case "x-large" -> 0.075f;
            default -> 0.035f;
        };
        PDDocument document = this.pdfDocumentFactory.load(pdfFile);
        List pageNumbers = request.getPageNumbersList(document, true);
        Iterator iterator = pageNumbers.iterator();
        while (iterator.hasNext()) {
            int pageIndex = (Integer)iterator.next();
            int zeroBasedIndex = pageIndex - 1;
            if (zeroBasedIndex < 0 || zeroBasedIndex >= document.getNumberOfPages()) continue;
            PDPage page = document.getPage(zeroBasedIndex);
            PDRectangle pageSize = page.getMediaBox();
            float margin = marginFactor * (pageSize.getWidth() + pageSize.getHeight()) / 2.0f;
            PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
            PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
            graphicsState.setNonStrokingAlphaConstant(Float.valueOf(opacity));
            contentStream.setGraphicsStateParameters(graphicsState);
            if ("text".equalsIgnoreCase(stampType)) {
                this.addTextStamp(contentStream, stampText, document, page, rotation, position, fontSize, alphabet, overrideX, overrideY, margin, customColor);
            } else if ("image".equalsIgnoreCase(stampType)) {
                this.addImageStamp(contentStream, stampImage, document, page, rotation, position, fontSize, overrideX, overrideY, margin);
            }
            contentStream.close();
        }
        return WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)pdfFile.getOriginalFilename(), (String)"_stamped.pdf"));
    }

    private void addTextStamp(PDPageContentStream contentStream, String stampText, PDDocument document, PDPage page, float rotation, int position, float fontSize, String alphabet, float overrideX, float overrideY, float margin, String colorString) throws IOException {
        float y;
        float x;
        Color redactColor;
        PDType1Font font = new PDType1Font(Standard14Fonts.FontName.HELVETICA);
        String resourceDir = switch (alphabet) {
            case "arabic" -> "static/fonts/NotoSansArabic-Regular.ttf";
            case "japanese" -> "static/fonts/NotoSansJP-Regular.ttf";
            case "korean" -> "static/fonts/NotoSansKR-Regular.ttf";
            case "chinese" -> "static/fonts/NotoSansSC-Regular.ttf";
            case "thai" -> "static/fonts/NotoSansThai-Regular.ttf";
            case "roman" -> "static/fonts/NotoSans-Regular.ttf";
            default -> "static/fonts/NotoSans-Regular.ttf";
        };
        ClassPathResource classPathResource = new ClassPathResource(resourceDir);
        String fileExtension = resourceDir.substring(resourceDir.lastIndexOf("."));
        try (TempFile tempFileWrapper = new TempFile(this.tempFileManager, fileExtension);){
            File tempFile = tempFileWrapper.getFile();
            try (InputStream is = classPathResource.getInputStream();
                 FileOutputStream os = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
                font = PDType0Font.load((PDDocument)document, (File)tempFile);
            }
        }
        contentStream.setFont((PDFont)font, fontSize);
        try {
            if (!((String)colorString).startsWith("#")) {
                colorString = "#" + (String)colorString;
            }
            redactColor = Color.decode((String)colorString);
        }
        catch (NumberFormatException e) {
            redactColor = Color.LIGHT_GRAY;
        }
        contentStream.setNonStrokingColor(redactColor);
        PDRectangle pageSize = page.getMediaBox();
        String[] lines = RegexPatternUtils.getInstance().getEscapedNewlinePattern().split(stampText);
        float ascent = font.getFontDescriptor().getAscent();
        float descent = font.getFontDescriptor().getDescent();
        float lineHeight = (ascent - descent) / 1000.0f * fontSize;
        float capHeight = this.calculateTextCapHeight((PDFont)font, fontSize);
        float blockHeight = Math.max(lineHeight, lineHeight * (float)Math.max(1, lines.length));
        float maxWidth = 0.0f;
        for (String ln : lines) {
            maxWidth = Math.max(maxWidth, this.calculateTextWidth(ln, (PDFont)font, fontSize));
        }
        if (overrideX >= 0.0f && overrideY >= 0.0f) {
            x = overrideX;
            y = overrideY;
        } else {
            x = this.calculatePositionX(pageSize, position, maxWidth, null, 0.0f, null, margin);
            y = this.calculatePositionY(pageSize, position, blockHeight, margin);
        }
        float adjustedX = x;
        float adjustedY = y;
        float pivotX = adjustedX + maxWidth / 2.0f;
        float pivotY = adjustedY + blockHeight / 2.0f;
        contentStream.saveGraphicsState();
        contentStream.transform(Matrix.getTranslateInstance((float)pivotX, (float)pivotY));
        contentStream.transform(Matrix.getRotateInstance((double)Math.toRadians(rotation), (float)0.0f, (float)0.0f));
        contentStream.transform(Matrix.getTranslateInstance((float)(-pivotX), (float)(-pivotY)));
        contentStream.beginText();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            float yLine = adjustedY + blockHeight - capHeight - (float)i * lineHeight;
            contentStream.setTextMatrix(Matrix.getTranslateInstance((float)adjustedX, (float)yLine));
            contentStream.showText(line);
        }
        contentStream.endText();
        contentStream.restoreGraphicsState();
    }

    private void addImageStamp(PDPageContentStream contentStream, MultipartFile stampImage, PDDocument document, PDPage page, float rotation, int position, float fontSize, float overrideX, float overrideY, float margin) throws IOException {
        float y;
        float x;
        BufferedImage image = ImageIO.read(stampImage.getInputStream());
        float aspectRatio = (float)image.getWidth() / (float)image.getHeight();
        float desiredPhysicalHeight = fontSize;
        float desiredPhysicalWidth = desiredPhysicalHeight * aspectRatio;
        PDImageXObject xobject = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)image);
        PDRectangle pageSize = page.getMediaBox();
        if (overrideX >= 0.0f && overrideY >= 0.0f) {
            x = overrideX;
            y = overrideY;
        } else {
            x = this.calculatePositionX(pageSize, position, desiredPhysicalWidth, null, 0.0f, null, margin);
            y = this.calculatePositionY(pageSize, position, fontSize, margin);
        }
        contentStream.saveGraphicsState();
        float centerX = x + desiredPhysicalWidth / 2.0f;
        float centerY = y + desiredPhysicalHeight / 2.0f;
        contentStream.transform(Matrix.getTranslateInstance((float)centerX, (float)centerY));
        contentStream.transform(Matrix.getRotateInstance((double)Math.toRadians(rotation), (float)0.0f, (float)0.0f));
        contentStream.drawImage(xobject, -desiredPhysicalWidth / 2.0f, -desiredPhysicalHeight / 2.0f, desiredPhysicalWidth, desiredPhysicalHeight);
        contentStream.restoreGraphicsState();
    }

    private float calculatePositionX(PDRectangle pageSize, int position, float contentWidth, PDFont font, float fontSize, String text, float margin) throws IOException {
        float actualWidth = text != null ? this.calculateTextWidth(text, font, fontSize) : contentWidth;
        return switch (position % 3) {
            case 1 -> pageSize.getLowerLeftX() + margin;
            case 2 -> (pageSize.getWidth() - actualWidth) / 2.0f;
            case 0 -> pageSize.getUpperRightX() - actualWidth - margin;
            default -> 0.0f;
        };
    }

    private float calculatePositionY(PDRectangle pageSize, int position, float height, float margin) {
        return switch ((position - 1) / 3) {
            case 0 -> pageSize.getUpperRightY() - height - margin;
            case 1 -> (pageSize.getHeight() - height) / 2.0f;
            case 2 -> pageSize.getLowerLeftY() + margin;
            default -> 0.0f;
        };
    }

    private float calculateTextWidth(String text, PDFont font, float fontSize) throws IOException {
        return font.getStringWidth(text) / 1000.0f * fontSize;
    }

    private float calculateTextCapHeight(PDFont font, float fontSize) {
        return font.getFontDescriptor().getCapHeight() / 1000.0f * fontSize;
    }

    @Generated
    public StampController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
    }
}

