/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.MultiFileResponse;
import stirling.software.SPDF.model.api.PDFExtractImagesRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ImageProcessingUtils;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class ExtractImagesController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtractImagesController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/extract-images"})
    @MultiFileResponse
    @Operation(summary="Extract images from a PDF file", description="This endpoint extracts images from a given PDF file and returns them in a zip file. Users can specify the output image format. Input:PDF Output:IMAGE/ZIP Type:SIMO")
    public ResponseEntity<byte[]> extractImages(@ModelAttribute PDFExtractImagesRequest request) throws IOException, InterruptedException, ExecutionException {
        MultipartFile file = request.getFileInput();
        String format = request.getFormat();
        boolean allowDuplicates = Boolean.TRUE.equals(request.getAllowDuplicates());
        PDDocument document = this.pdfDocumentFactory.load(file);
        boolean useMultithreading = this.shouldUseMultithreading(file, document);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        zos.setLevel(9);
        String filename = GeneralUtils.removeExtension((String)file.getOriginalFilename());
        HashSet processedImages = new HashSet();
        if (useMultithreading) {
            ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            HashSet<Future<Void>> futures = new HashSet<Future<Void>>();
            try {
                int pageCount = document.getPages().getCount();
                log.debug("Document reports {} pages", (Object)pageCount);
                boolean bl = false;
                for (int pgNum = 0; pgNum < pageCount; ++pgNum) {
                    int n;
                    try {
                        PDPage page = document.getPage(pgNum);
                        n = 0;
                        int currentPageNum = pgNum + 1;
                        Future<Void> future = executor.submit(() -> {
                            try {
                                this.extractImagesFromPage(page, format, filename, currentPageNum, processedImages, zos, allowDuplicates);
                            }
                            catch (Exception e) {
                                ExceptionUtils.logException((String)("image extraction from page " + currentPageNum), (Exception)e);
                            }
                            return null;
                        });
                        futures.add(future);
                        continue;
                    }
                    catch (Exception e) {
                        ExceptionUtils.logException((String)("page access for page " + (pgNum + 1)), (Exception)e);
                        if (++n < 3) continue;
                        log.warn("Stopping page iteration after 3 consecutive failures");
                        break;
                    }
                }
            }
            catch (Exception e) {
                ExceptionUtils.logException((String)"page count determination", (Exception)e);
                throw e;
            }
            for (Future future : futures) {
                future.get();
            }
            executor.shutdown();
        } else {
            for (int pgNum = 0; pgNum < document.getPages().getCount(); ++pgNum) {
                PDPage page = document.getPage(pgNum);
                this.extractImagesFromPage(page, format, filename, pgNum + 1, processedImages, zos, allowDuplicates);
            }
        }
        document.close();
        zos.close();
        byte[] zipContents = baos.toByteArray();
        return WebResponseUtils.baosToWebResponse((ByteArrayOutputStream)baos, (String)(filename + "_extracted-images.zip"), (MediaType)MediaType.APPLICATION_OCTET_STREAM);
    }

    private boolean shouldUseMultithreading(MultipartFile file, PDDocument document) {
        long fileSizeInMB = file.getSize() / 0x100000L;
        int numberOfPages = document.getPages().getCount();
        return fileSizeInMB > 10L || numberOfPages > 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractImagesFromPage(PDPage page, String format, String filename, int pageNum, Set<byte[]> processedImages, ZipOutputStream zos, boolean allowDuplicates) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("MD5 algorithm not available for extractImages hash.", (Throwable)e);
            return;
        }
        if (page.getResources() == null || page.getResources().getXObjectNames() == null) {
            return;
        }
        int count = 1;
        for (COSName name : page.getResources().getXObjectNames()) {
            try {
                if (!page.getResources().isImageXObject(name)) continue;
                PDImageXObject image = (PDImageXObject)page.getResources().getXObject(name);
                if (!allowDuplicates) {
                    byte[] data = ImageProcessingUtils.getImageData((BufferedImage)image.getImage());
                    byte[] imageHash = md.digest(data);
                    Set<byte[]> set = processedImages;
                    synchronized (set) {
                        if (processedImages.stream().anyMatch(hash -> Arrays.equals(hash, imageHash))) {
                            continue;
                        }
                        processedImages.add(imageHash);
                    }
                }
                BufferedImage renderedImage = image.getImage();
                BufferedImage bufferedImage = this.convertToRGB((RenderedImage)renderedImage, format);
                String imageName = filename + "_page_" + pageNum + "_" + count++ + "." + format;
                ZipOutputStream zipOutputStream = zos;
                synchronized (zipOutputStream) {
                    zos.putNextEntry(new ZipEntry(imageName));
                    ByteArrayOutputStream imageBaos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, format, imageBaos);
                    zos.write(imageBaos.toByteArray());
                    zos.closeEntry();
                }
            }
            catch (IOException e) {
                ExceptionUtils.logException((String)"image extraction", (Exception)e);
                throw ExceptionUtils.handlePdfException((IOException)e, (String)"during image extraction");
            }
        }
    }

    private BufferedImage convertToRGB(RenderedImage renderedImage, String format) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        BufferedImage rgbImage = "png".equalsIgnoreCase(format) ? new BufferedImage(width, height, 2) : ("jpeg".equalsIgnoreCase(format) || "jpg".equalsIgnoreCase(format) ? new BufferedImage(width, height, 1) : ("gif".equalsIgnoreCase(format) ? new BufferedImage(width, height, 13) : new BufferedImage(width, height, 1)));
        Graphics2D g = rgbImage.createGraphics();
        g.drawImage((Image)((Object)renderedImage), 0, 0, null);
        g.dispose();
        return rgbImage;
    }

    @Generated
    public ExtractImagesController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

