/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.MultiFileResponse;
import stirling.software.SPDF.model.api.PDFWithPageNums;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class SplitPDFController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SplitPDFController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/split-pages"})
    @MultiFileResponse
    @Operation(summary="Split a PDF file into separate documents", description="This endpoint splits a given PDF file into separate documents based on the specified page numbers or ranges. Users can specify pages using individual numbers, ranges, or 'all' for every page. Input:PDF Output:PDF Type:SIMO")
    public ResponseEntity<byte[]> splitPdf(@ModelAttribute PDFWithPageNums request) throws IOException {
        PDDocument document = null;
        ArrayList<ByteArrayOutputStream> splitDocumentsBoas = new ArrayList<ByteArrayOutputStream>();
        TempFile outputTempFile = null;
        try {
            outputTempFile = new TempFile(this.tempFileManager, ".zip");
            MultipartFile file = request.getFileInput();
            document = this.pdfDocumentFactory.load(file);
            int totalPages = document.getNumberOfPages();
            ArrayList<Integer> pageNumbers = request.getPageNumbersList(document, false);
            if (!pageNumbers.contains(totalPages - 1)) {
                pageNumbers = new ArrayList<Integer>(pageNumbers);
                pageNumbers.add(totalPages - 1);
            }
            log.debug("Splitting PDF into pages: {}", (Object)pageNumbers.stream().map(String::valueOf).collect(Collectors.joining(",")));
            splitDocumentsBoas = new ArrayList(pageNumbers.size());
            int previousPageNumber = 0;
            Iterator iterator = pageNumbers.iterator();
            while (iterator.hasNext()) {
                int splitPoint = (Integer)iterator.next();
                try {
                    PDDocument splitDocument = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(document);
                    try {
                        for (int i = previousPageNumber; i <= splitPoint; ++i) {
                            PDPage page = document.getPage(i);
                            splitDocument.addPage(page);
                            log.debug("Adding page {} to split document", (Object)i);
                        }
                        previousPageNumber = splitPoint + 1;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        splitDocument.save((OutputStream)baos);
                        splitDocumentsBoas.add(baos);
                    }
                    finally {
                        if (splitDocument == null) continue;
                        splitDocument.close();
                    }
                }
                catch (Exception e) {
                    ExceptionUtils.logException((String)"document splitting and saving", (Exception)e);
                    throw e;
                }
            }
            document.close();
            String baseFilename = GeneralUtils.removeExtension((String)file.getOriginalFilename());
            try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(outputTempFile.getPath(), new OpenOption[0]));){
                int splitDocumentsSize = splitDocumentsBoas.size();
                for (int i = 0; i < splitDocumentsSize; ++i) {
                    StringBuilder sb = new StringBuilder(baseFilename.length() + 10);
                    sb.append(baseFilename).append('_').append(i + 1).append(".pdf");
                    String fileName = sb.toString();
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)splitDocumentsBoas.get(i);
                    byte[] pdf = baos.toByteArray();
                    ZipEntry pdfEntry = new ZipEntry(fileName);
                    zipOut.putNextEntry(pdfEntry);
                    zipOut.write(pdf);
                    zipOut.closeEntry();
                    log.debug("Wrote split document {} to zip file", (Object)fileName);
                }
            }
            log.debug("Successfully created zip file with split documents: {}", (Object)outputTempFile.getPath().toString());
            byte[] data = Files.readAllBytes(outputTempFile.getPath());
            String zipFilename = GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"_split.zip");
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])data, (String)zipFilename, (MediaType)MediaType.APPLICATION_OCTET_STREAM);
            return responseEntity;
        }
        finally {
            try {
                if (document != null) {
                    document.close();
                }
                for (ByteArrayOutputStream baos : splitDocumentsBoas) {
                    if (baos == null) continue;
                    baos.close();
                }
                if (outputTempFile != null) {
                    outputTempFile.close();
                }
            }
            catch (Exception e) {
                log.error("Error while cleaning up resources", (Throwable)e);
            }
        }
    }

    @Generated
    public SplitPDFController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
    }
}

