/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.general.OverlayPdfsRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.service.CustomPDFDocumentFactory;

@GeneralApi
public class PdfOverlayController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    /*
     * Exception decompiling
     */
    @AutoJobPostMapping(value={"/overlay-pdfs"}, consumes={"multipart/form-data"})
    @StandardPdfResponse
    @Operation(summary="Overlay PDF files in various modes", description="Overlay PDF files onto a base PDF with different modes: Sequential, Interleaved, or Fixed Repeat. Input:PDF Output:PDF Type:MIMO")
    public ResponseEntity<byte[]> overlayPdfs(@ModelAttribute OverlayPdfsRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<Integer, String> prepareOverlayGuide(int basePageCount, File[] overlayFiles, String mode, int[] counts, List<File> tempFiles) throws IOException {
        HashMap<Integer, String> overlayGuide = new HashMap<Integer, String>();
        switch (mode) {
            case "SequentialOverlay": {
                this.sequentialOverlay(overlayGuide, overlayFiles, basePageCount, tempFiles);
                break;
            }
            case "InterleavedOverlay": {
                this.interleavedOverlay(overlayGuide, overlayFiles, basePageCount);
                break;
            }
            case "FixedRepeatOverlay": {
                this.fixedRepeatOverlay(overlayGuide, overlayFiles, counts, basePageCount);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid overlay mode");
            }
        }
        return overlayGuide;
    }

    private void sequentialOverlay(Map<Integer, String> overlayGuide, File[] overlayFiles, int basePageCount, List<File> tempFiles) throws IOException {
        int overlayFileIndex = 0;
        int pageCountInCurrentOverlay = 0;
        for (int basePageIndex = 1; basePageIndex <= basePageCount; ++basePageIndex) {
            if (pageCountInCurrentOverlay == 0 || pageCountInCurrentOverlay >= this.getNumberOfPages(overlayFiles[overlayFileIndex])) {
                pageCountInCurrentOverlay = 0;
                overlayFileIndex = (overlayFileIndex + 1) % overlayFiles.length;
            }
            try (PDDocument overlayPdf = Loader.loadPDF((File)overlayFiles[overlayFileIndex]);){
                PDDocument singlePageDocument = new PDDocument();
                singlePageDocument.addPage(overlayPdf.getPage(pageCountInCurrentOverlay));
                File tempFile = Files.createTempFile("overlay-page-", ".pdf", new FileAttribute[0]).toFile();
                singlePageDocument.save(tempFile);
                singlePageDocument.close();
                overlayGuide.put(basePageIndex, tempFile.getAbsolutePath());
                tempFiles.add(tempFile);
            }
            ++pageCountInCurrentOverlay;
        }
    }

    private int getNumberOfPages(File file) throws IOException {
        try (PDDocument doc = Loader.loadPDF((File)file);){
            int n = doc.getNumberOfPages();
            return n;
        }
    }

    private void interleavedOverlay(Map<Integer, String> overlayGuide, File[] overlayFiles, int basePageCount) throws IOException {
        for (int basePageIndex = 1; basePageIndex <= basePageCount; ++basePageIndex) {
            File overlayFile = overlayFiles[(basePageIndex - 1) % overlayFiles.length];
            try (PDDocument overlayPdf = Loader.loadPDF((File)overlayFile);){
                int overlayPageCount = overlayPdf.getNumberOfPages();
                if ((basePageIndex - 1) % overlayPageCount >= overlayPageCount) continue;
                overlayGuide.put(basePageIndex, overlayFile.getAbsolutePath());
                continue;
            }
        }
    }

    private void fixedRepeatOverlay(Map<Integer, String> overlayGuide, File[] overlayFiles, int[] counts, int basePageCount) throws IOException {
        if (overlayFiles.length != counts.length) {
            throw new IllegalArgumentException("Counts array length must match the number of overlay files");
        }
        int currentPage = 1;
        for (int i = 0; i < overlayFiles.length; ++i) {
            File overlayFile = overlayFiles[i];
            int repeatCount = counts[i];
            try (PDDocument overlayPdf = Loader.loadPDF((File)overlayFile);){
                int overlayPageCount = overlayPdf.getNumberOfPages();
                for (int j = 0; j < repeatCount; ++j) {
                    for (int page = 0; page < overlayPageCount && currentPage <= basePageCount; ++page) {
                        overlayGuide.put(currentPage++, overlayFile.getAbsolutePath());
                    }
                }
                continue;
            }
        }
    }

    @Generated
    public PdfOverlayController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

