/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import stirling.software.SPDF.service.LanguageService;

@RestController
@RequestMapping(value={"/js"})
public class AdditionalLanguageJsController {
    private final LanguageService languageService;

    @Hidden
    @GetMapping(value={"/additionalLanguageCode.js"}, produces={"application/javascript"})
    public void generateAdditionalLanguageJs(HttpServletResponse response) throws IOException {
        Set supportedLanguages = this.languageService.getSupportedLanguages();
        response.setContentType("application/javascript");
        PrintWriter writer = response.getWriter();
        writer.println("const supportedLanguages = " + this.toJsonArray(new ArrayList(supportedLanguages)) + ";");
        writer.println("function getDetailedLanguageCode() {\n    const userLanguages = navigator.languages ? navigator.languages : [navigator.language];\n    for (let lang of userLanguages) {\n        let matchedLang = supportedLanguages.find(supportedLang => supportedLang.startsWith(lang.replace('-', '_')));\n        if (matchedLang) {\n            return matchedLang;\n        }\n    }\n    // Fallback\n    return \"en_GB\";\n}\n");
        writer.flush();
    }

    private String toJsonArray(List<String> list) {
        StringBuilder jsonArray = new StringBuilder("[");
        for (int i = 0; i < list.size(); ++i) {
            jsonArray.append("\"").append(list.get(i)).append("\"");
            if (i >= list.size() - 1) continue;
            jsonArray.append(",");
        }
        jsonArray.append("]");
        return jsonArray.toString();
    }

    @Generated
    public AdditionalLanguageJsController(LanguageService languageService) {
        this.languageService = languageService;
    }
}

