/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class CleanUrlInterceptor
implements HandlerInterceptor {
    private static final List<String> ALLOWED_PARAMS = Arrays.asList("lang", "endpoint", "endpoints", "logout", "error", "days", "date", "errorOAuth", "file", "messageType", "infoMessage", "page", "size", "type", "principal", "startDate", "endDate", "async");

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestURI = request.getRequestURI();
        if (requestURI.contains("/api/")) {
            return true;
        }
        String queryString = request.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            String[] queryParameters;
            HashMap<String, String> allowedParameters = new HashMap<String, String>();
            for (String param : queryParameters = queryString.split("&")) {
                String[] keyValuePair = param.split("=");
                if (keyValuePair.length != 2 || !ALLOWED_PARAMS.contains(keyValuePair[0])) continue;
                allowedParameters.put(keyValuePair[0], keyValuePair[1]);
            }
            if (allowedParameters.size() != queryParameters.length) {
                StringBuilder newQueryString = new StringBuilder();
                for (Map.Entry entry : allowedParameters.entrySet()) {
                    if (!newQueryString.isEmpty()) {
                        newQueryString.append("&");
                    }
                    newQueryString.append((String)entry.getKey()).append("=").append((String)entry.getValue());
                }
                String redirectUrl = requestURI + "?" + String.valueOf(newQueryString);
                response.sendRedirect(request.getContextPath() + redirectUrl);
                return false;
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
    }
}

