/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.StandardCopyOption;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.RefDirectoryUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RefDirectoryRename
extends RefRename {
    private static final Logger LOG = LoggerFactory.getLogger(RefDirectoryRename.class);
    private final RefDirectory refdb;
    private ObjectId objId;
    private boolean updateHEAD;
    private RefDirectoryUpdate tmp;

    RefDirectoryRename(RefDirectoryUpdate src, RefDirectoryUpdate dst) {
        super(src, dst);
        this.refdb = src.getRefDatabase();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected RefUpdate.Result doRename() throws IOException {
        if (this.source.getRef().isSymbolic()) {
            return RefUpdate.Result.IO_FAILURE;
        }
        this.objId = this.source.getOldObjectId();
        this.updateHEAD = this.needToUpdateHEAD();
        this.tmp = this.refdb.newTemporaryUpdate();
        try {
            block48: {
                block47: {
                    block46: {
                        block45: {
                            block44: {
                                rw = new RevWalk(this.refdb.getRepository());
                                try {
                                    this.tmp.setNewObjectId(this.objId);
                                    this.tmp.setForceUpdate(true);
                                    this.tmp.disableRefLog();
                                    switch (1.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[this.tmp.update(rw).ordinal()]) {
                                        case 1: 
                                        case 2: 
                                        case 3: {
                                            ** break;
                                        }
                                        default: {
                                            var2_2 = this.tmp.getResult();
                                            rw.close();
                                            return var2_2;
lbl19:
                                            // 1 sources

                                        }
                                    }
                                }
                                catch (Throwable var2_5) {
                                    try {
                                        rw.close();
                                    }
                                    catch (Throwable var3_13) {
                                        var2_5.addSuppressed(var3_13);
                                    }
                                    throw var2_5;
                                }
                                if (this.renameLog(this.source, this.tmp)) break block44;
                                var2_3 = RefUpdate.Result.IO_FAILURE;
                                rw.close();
                                return var2_3;
                            }
                            dst = this.destination;
                            if (!this.updateHEAD) ** GOTO lbl50
                            if (this.linkHEAD(this.destination)) break block45;
                            this.renameLog(this.tmp, this.source);
                            var3_8 = RefUpdate.Result.LOCK_FAILURE;
                            rw.close();
                            return var3_8;
                        }
                        dst = this.refdb.newUpdate("HEAD", false);
                        dst.setRefLogIdent(this.destination.getRefLogIdent());
                        dst.setRefLogMessage(this.destination.getRefLogMessage(), false);
lbl50:
                        // 2 sources

                        this.source.setExpectedOldObjectId(this.objId);
                        this.source.setForceUpdate(true);
                        this.source.disableRefLog();
                        if (this.source.delete(rw) == RefUpdate.Result.FORCED) break block46;
                        this.renameLog(this.tmp, this.source);
                        if (this.updateHEAD) {
                            this.linkHEAD(this.source);
                        }
                        var3_9 = this.source.getResult();
                        rw.close();
                        return var3_9;
                    }
                    if (this.renameLog(this.tmp, this.destination)) break block47;
                    this.renameLog(this.tmp, this.source);
                    this.source.setExpectedOldObjectId(ObjectId.zeroId());
                    this.source.setNewObjectId(this.objId);
                    this.source.update(rw);
                    if (this.updateHEAD) {
                        this.linkHEAD(this.source);
                    }
                    var3_10 = RefUpdate.Result.IO_FAILURE;
                    rw.close();
                    return var3_10;
                }
                dst.setExpectedOldObjectId(ObjectId.zeroId());
                dst.setNewObjectId(this.objId);
                if (dst.update(rw) == RefUpdate.Result.NEW) break block48;
                if (this.renameLog(this.destination, this.tmp)) {
                    this.renameLog(this.tmp, this.source);
                }
                this.source.setExpectedOldObjectId(ObjectId.zeroId());
                this.source.setNewObjectId(this.objId);
                this.source.update(rw);
                if (this.updateHEAD) {
                    this.linkHEAD(this.source);
                }
                var3_11 = dst.getResult();
                rw.close();
                return var3_11;
            }
            var3_12 = RefUpdate.Result.RENAMED;
            rw.close();
            return var3_12;
        }
        finally {
            try {
                this.refdb.delete(this.tmp);
            }
            catch (IOException err) {
                FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
            }
        }
    }

    private boolean renameLog(RefUpdate src, RefUpdate dst) {
        File srcLog = this.refdb.logFor(src.getName());
        File dstLog = this.refdb.logFor(dst.getName());
        if (!srcLog.exists()) {
            return true;
        }
        if (!RefDirectoryRename.rename(srcLog, dstLog)) {
            return false;
        }
        try {
            int levels = RefDirectory.levelsIn(src.getName()) - 2;
            RefDirectory.delete(srcLog, levels);
            return true;
        }
        catch (IOException e) {
            RefDirectoryRename.rename(dstLog, srcLog);
            return false;
        }
    }

    private static boolean rename(File src, File dst) {
        try {
            FileUtils.rename(src, dst, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (AtomicMoveNotSupportedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            // empty catch block
        }
        File dir = dst.getParentFile();
        if (!(!dir.exists() && dir.mkdirs() || dir.isDirectory())) {
            return false;
        }
        try {
            FileUtils.rename(src, dst, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean linkHEAD(RefUpdate target) {
        try {
            RefDirectoryUpdate u = this.refdb.newUpdate("HEAD", false);
            u.disableRefLog();
            switch (u.link(target.getName())) {
                case NEW: 
                case FORCED: 
                case NO_CHANGE: {
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

