/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.api.ApplyResult;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.PatchApplyException;
import org.eclipse.jgit.api.errors.PatchFormatException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.patch.Patch;
import org.eclipse.jgit.util.FileUtils;

public class ApplyCommand
extends GitCommand<ApplyResult> {
    private InputStream in;

    ApplyCommand(Repository repo) {
        super(repo);
    }

    public ApplyCommand setPatch(InputStream in) {
        this.checkCallable();
        this.in = in;
        return this;
    }

    @Override
    public ApplyResult call() throws GitAPIException, PatchFormatException, PatchApplyException {
        this.checkCallable();
        ApplyResult r = new ApplyResult();
        try {
            Patch p = new Patch();
            try {
                p.parse(this.in);
            }
            finally {
                this.in.close();
            }
            if (!p.getErrors().isEmpty()) {
                throw new PatchFormatException(p.getErrors());
            }
            for (FileHeader fileHeader : p.getFiles()) {
                DiffEntry.ChangeType type = fileHeader.getChangeType();
                File f = null;
                switch (type) {
                    case ADD: {
                        f = this.getFile(fileHeader.getNewPath(), true);
                        this.apply(f, fileHeader);
                        break;
                    }
                    case MODIFY: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        this.apply(f, fileHeader);
                        break;
                    }
                    case DELETE: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        if (f.delete()) break;
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().cannotDeleteFile, f));
                    }
                    case RENAME: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        File dest = this.getFile(fileHeader.getNewPath(), false);
                        try {
                            FileUtils.mkdirs(dest.getParentFile(), true);
                            FileUtils.rename(f, dest, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (IOException e) {
                            throw new PatchApplyException(MessageFormat.format(JGitText.get().renameFileFailed, f, dest), e);
                        }
                        this.apply(dest, fileHeader);
                        break;
                    }
                    case COPY: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        File target = this.getFile(fileHeader.getNewPath(), false);
                        FileUtils.mkdirs(target.getParentFile(), true);
                        Files.copy(f.toPath(), target.toPath(), new CopyOption[0]);
                        this.apply(target, fileHeader);
                    }
                }
                r.addUpdatedFile(f);
            }
        }
        catch (IOException e) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, e.getMessage()), e);
        }
        this.setCallable(false);
        return r;
    }

    private File getFile(String path, boolean create) throws PatchApplyException {
        File f = new File(this.getRepository().getWorkTree(), path);
        if (create) {
            try {
                File parent = f.getParentFile();
                FileUtils.mkdirs(parent, true);
                FileUtils.createNewFile(f);
            }
            catch (IOException e) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().createNewFileFailed, f), e);
            }
        }
        return f;
    }

    private void apply(File f, FileHeader fh) throws IOException, PatchApplyException {
        RawText rt = new RawText(f);
        ArrayList<String> oldLines = new ArrayList<String>(rt.size());
        for (int i = 0; i < rt.size(); ++i) {
            oldLines.add(rt.getString(i));
        }
        ArrayList<String> newLines = new ArrayList<String>(oldLines);
        int afterLastHunk = 0;
        int lineNumberShift = 0;
        int lastHunkNewLine = -1;
        for (HunkHeader hunkHeader : fh.getHunks()) {
            boolean applies;
            int applyAt;
            ArrayList<String> hunkLines;
            block30: {
                int shift;
                int oldLinesInHunk;
                block29: {
                    if (hunkHeader.getNewStartLine() <= lastHunkNewLine) {
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
                    }
                    lastHunkNewLine = hunkHeader.getNewStartLine();
                    byte[] b = new byte[hunkHeader.getEndOffset() - hunkHeader.getStartOffset()];
                    System.arraycopy(hunkHeader.getBuffer(), hunkHeader.getStartOffset(), b, 0, b.length);
                    RawText hrt = new RawText(b);
                    hunkLines = new ArrayList<String>(hrt.size());
                    for (int i = 0; i < hrt.size(); ++i) {
                        hunkLines.add(hrt.getString(i));
                    }
                    if (hunkHeader.getNewStartLine() == 0) {
                        if (fh.getHunks().size() == 1 && this.canApplyAt(hunkLines, newLines, 0)) {
                            newLines.clear();
                            break;
                        }
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
                    }
                    applyAt = hunkHeader.getNewStartLine() - 1 + lineNumberShift;
                    if (applyAt < afterLastHunk && lineNumberShift < 0) {
                        applyAt = hunkHeader.getNewStartLine() - 1;
                        lineNumberShift = 0;
                    }
                    if (applyAt < afterLastHunk) {
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
                    }
                    applies = false;
                    oldLinesInHunk = hunkHeader.getLinesContext() + hunkHeader.getOldImage().getLinesDeleted();
                    if (oldLinesInHunk > 1) break block29;
                    applies = this.canApplyAt(hunkLines, newLines, applyAt);
                    if (applies || lineNumberShift == 0) break block30;
                    applyAt = hunkHeader.getNewStartLine() - 1;
                    applies = applyAt >= afterLastHunk && this.canApplyAt(hunkLines, newLines, applyAt);
                    break block30;
                }
                int maxShift = applyAt - afterLastHunk;
                for (shift = 0; shift <= maxShift; ++shift) {
                    if (!this.canApplyAt(hunkLines, newLines, applyAt - shift)) continue;
                    applies = true;
                    applyAt -= shift;
                    break;
                }
                if (!applies) {
                    applyAt = hunkHeader.getNewStartLine() - 1 + lineNumberShift;
                    maxShift = newLines.size() - applyAt - oldLinesInHunk;
                    for (shift = 1; shift <= maxShift; ++shift) {
                        if (!this.canApplyAt(hunkLines, newLines, applyAt + shift)) continue;
                        applies = true;
                        applyAt += shift;
                        break;
                    }
                }
            }
            if (!applies) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
            }
            lineNumberShift = applyAt - hunkHeader.getNewStartLine() + 1;
            int sz = hunkLines.size();
            block15: for (int j = 1; j < sz; ++j) {
                String hunkLine = (String)hunkLines.get(j);
                switch (hunkLine.charAt(0)) {
                    case ' ': {
                        ++applyAt;
                        continue block15;
                    }
                    case '-': {
                        newLines.remove(applyAt);
                        continue block15;
                    }
                    case '+': {
                        newLines.add(applyAt++, hunkLine.substring(1));
                        continue block15;
                    }
                }
            }
            afterLastHunk = applyAt;
        }
        if (!this.isNoNewlineAtEndOfFile(fh)) {
            newLines.add("");
        }
        if (!rt.isMissingNewlineAtEnd()) {
            oldLines.add("");
        }
        if (!ApplyCommand.isChanged(oldLines, newLines)) {
            return;
        }
        try (BufferedWriter fw = Files.newBufferedWriter(f.toPath(), new OpenOption[0]);){
            Iterator iterator = newLines.iterator();
            while (iterator.hasNext()) {
                fw.write((String)iterator.next());
                if (!iterator.hasNext()) continue;
                ((Writer)fw).write(10);
            }
        }
        this.getRepository().getFS().setExecute(f, fh.getNewMode() == FileMode.EXECUTABLE_FILE);
    }

    private boolean canApplyAt(List<String> hunkLines, List<String> newLines, int line) {
        int sz = hunkLines.size();
        int limit = newLines.size();
        int pos = line;
        block3: for (int j = 1; j < sz; ++j) {
            String hunkLine = hunkLines.get(j);
            switch (hunkLine.charAt(0)) {
                case ' ': 
                case '-': {
                    if (pos >= limit || !newLines.get(pos).equals(hunkLine.substring(1))) {
                        return false;
                    }
                    ++pos;
                    continue block3;
                }
            }
        }
        return true;
    }

    private static boolean isChanged(List<String> ol, List<String> nl) {
        if (ol.size() != nl.size()) {
            return true;
        }
        for (int i = 0; i < ol.size(); ++i) {
            if (ol.get(i).equals(nl.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isNoNewlineAtEndOfFile(FileHeader fh) {
        List<? extends HunkHeader> hunks = fh.getHunks();
        if (hunks == null || hunks.isEmpty()) {
            return false;
        }
        HunkHeader lastHunk = hunks.get(hunks.size() - 1);
        RawText lhrt = new RawText(lastHunk.getBuffer());
        return lhrt.getString(lhrt.size() - 1).equals("\\ No newline at end of file");
    }
}

